/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.state.blockstream.BlockStreamInfo;
import com.hedera.hapi.node.state.file.File;
import com.hedera.node.app.blocks.schemas.V0560BlockStreamSchema;
import com.hedera.node.app.config.BootstrapConfigProviderImpl;
import com.hedera.node.app.config.ConfigProviderImpl;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.records.BlockRecordService;
import com.hedera.node.app.records.schemas.V0490BlockRecordSchema;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.file.impl.FileServiceImpl;
import com.hedera.node.app.service.file.impl.schemas.V0490FileSchema;
import com.hedera.node.app.service.schedule.ScheduleService;
import com.hedera.node.app.service.schedule.ScheduleServiceApi;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.service.token.impl.api.TokenServiceApiProvider;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.state.WorkingStateAccessor;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.throttle.ThrottleServiceManager;
import com.hedera.node.app.util.FileUtilities;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.types.StreamMode;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Module
public interface FacilityInitModule {
    public static final Logger log = LogManager.getLogger(FacilityInitModule.class);

    @Provides
    @Singleton
    public static Supplier<FeeCharging> provideBaseFeeCharging(@NonNull AppContext appContext) {
        Objects.requireNonNull(appContext);
        return appContext.feeChargingSupplier();
    }

    @Provides
    @Singleton
    public static Map<Class<?>, ServiceApiProvider<?>> provideApiProviders(@NonNull ScheduleService scheduleService) {
        Objects.requireNonNull(scheduleService);
        return Map.of(TokenServiceApi.class, TokenServiceApiProvider.TOKEN_SERVICE_API_PROVIDER, ScheduleServiceApi.class, scheduleService.apiProvider());
    }

    @Binds
    @Singleton
    public ConfigProvider bindConfigProvider(@NonNull ConfigProviderImpl var1);

    @Provides
    @Singleton
    public static FacilityInitializer initFacilities(@NonNull FeeManager feeManager, @NonNull FileServiceImpl fileService, @NonNull ConfigProviderImpl configProvider, @NonNull BootstrapConfigProviderImpl bootstrapConfigProvider, @NonNull ExchangeRateManager exchangeRateManager, @NonNull ThrottleServiceManager throttleServiceManager, @NonNull WorkingStateAccessor workingStateAccessor) {
        return (state, streamMode) -> {
            Objects.requireNonNull(state);
            Objects.requireNonNull(streamMode);
            if (FacilityInitModule.hasHandledGenesisTxn(state, streamMode)) {
                FacilityInitModule.initializeExchangeRateManager(state, configProvider, exchangeRateManager);
                FacilityInitModule.initializeFeeManager(state, configProvider, feeManager);
                FileUtilities.observePropertiesAndPermissions(state, (Configuration)configProvider.getConfiguration(), (properties, permissions) -> {
                    if (!Bytes.EMPTY.equals((Object)properties) || !Bytes.EMPTY.equals((Object)permissions)) {
                        configProvider.update(properties, permissions);
                    }
                });
                throttleServiceManager.init(state, FacilityInitModule.throttleDefinitionsFrom(state, configProvider));
            } else {
                V0490FileSchema schema = fileService.fileSchema();
                VersionedConfiguration bootstrapConfig = bootstrapConfigProvider.getConfiguration();
                exchangeRateManager.init(state, schema.genesisExchangeRates((Configuration)bootstrapConfig));
                feeManager.update(schema.genesisFeeSchedules((Configuration)bootstrapConfig));
                throttleServiceManager.init(state, schema.genesisThrottleDefinitions((Configuration)bootstrapConfig));
            }
            workingStateAccessor.setState(state);
        };
    }

    private static void initializeExchangeRateManager(@NonNull State state, @NonNull ConfigProvider configProvider, @NonNull ExchangeRateManager exchangeRateManager) {
        FilesConfig filesConfig = (FilesConfig)configProvider.getConfiguration().getConfigData(FilesConfig.class);
        long fileNum = filesConfig.exchangeRates();
        File file = Objects.requireNonNull(FacilityInitModule.getFileFromStorage(state, configProvider, fileNum), "The initialized state had no exchange rates file 0.0." + fileNum);
        exchangeRateManager.init(state, file.contents());
    }

    private static void initializeFeeManager(@NonNull State state, @NonNull ConfigProvider configProvider, @NonNull FeeManager feeManager) {
        log.info("Initializing fee schedules");
        FilesConfig filesConfig = (FilesConfig)configProvider.getConfiguration().getConfigData(FilesConfig.class);
        long fileNum = filesConfig.feeSchedules();
        File file = Objects.requireNonNull(FacilityInitModule.getFileFromStorage(state, configProvider, fileNum), "The initialized state had no fee schedule file 0.0." + fileNum);
        ResponseCodeEnum status = feeManager.update(file.contents());
        if (status != ResponseCodeEnum.SUCCESS) {
            log.error("State file 0.0.{} did not contain parseable fee schedules ({})", (Object)fileNum, (Object)status);
        }
    }

    private static boolean hasHandledGenesisTxn(@NonNull State state, @NonNull StreamMode streamMode) {
        if (streamMode == StreamMode.RECORDS) {
            BlockInfo blockInfo = (BlockInfo)state.getReadableStates("BlockRecordService").getSingleton(V0490BlockRecordSchema.BLOCKS_STATE_ID).get();
            return !BlockRecordService.EPOCH.equals((Object)Optional.ofNullable(blockInfo).map(BlockInfo::consTimeOfLastHandledTxn).orElse(BlockRecordService.EPOCH));
        }
        BlockStreamInfo blockStreamInfo = (BlockStreamInfo)state.getReadableStates("BlockStreamService").getSingleton(V0560BlockStreamSchema.BLOCK_STREAM_INFO_STATE_ID).get();
        return !BlockRecordService.EPOCH.equals((Object)Optional.ofNullable(blockStreamInfo).map(BlockStreamInfo::lastHandleTime).orElse(BlockRecordService.EPOCH));
    }

    @Nullable
    private static File getFileFromStorage(@NonNull State state, @NonNull ConfigProvider configProvider, long fileNum) {
        ReadableFileStore readableFileStore = new ReadableStoreFactory(state).getStore(ReadableFileStore.class);
        HederaConfig hederaConfig = (HederaConfig)configProvider.getConfiguration().getConfigData(HederaConfig.class);
        FileID fileId = FileID.newBuilder().fileNum(fileNum).shardNum(hederaConfig.shard()).realmNum(hederaConfig.realm()).build();
        return readableFileStore.getFileLeaf(fileId);
    }

    private static Bytes throttleDefinitionsFrom(@NonNull State state, @NonNull ConfigProvider configProvider) {
        VersionedConfiguration config = configProvider.getConfiguration();
        FilesConfig filesConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        FileID throttleDefinitionsId = FileUtilities.createFileID(filesConfig.throttleDefinitions(), (Configuration)config);
        return FileUtilities.getFileContent(state, throttleDefinitionsId);
    }

    @FunctionalInterface
    public static interface FacilityInitializer {
        public void initialize(@NonNull State var1, @NonNull StreamMode var2);
    }
}

