/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.ingest;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.contract.ContractUpdateTransactionBody;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.token.CryptoUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.annotations.NodeSelfId;
import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.fees.FeeContextImpl;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.hapi.utils.EthSigsUtils;
import com.hedera.node.app.info.CurrentPlatformStatus;
import com.hedera.node.app.signature.DefaultKeyVerifier;
import com.hedera.node.app.signature.ExpandedSignaturePair;
import com.hedera.node.app.signature.SignatureExpander;
import com.hedera.node.app.signature.SignatureVerificationFuture;
import com.hedera.node.app.signature.SignatureVerifier;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.state.DeduplicationCache;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.throttle.SynchronizedThrottleAccumulator;
import com.hedera.node.app.throttle.ThrottleUsage;
import com.hedera.node.app.workflows.InnerTransaction;
import com.hedera.node.app.workflows.OpWorkflowMetrics;
import com.hedera.node.app.workflows.SolvencyPreCheck;
import com.hedera.node.app.workflows.TransactionChecker;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.handle.dispatch.DispatchValidator;
import com.hedera.node.app.workflows.purechecks.PureChecksContextImpl;
import com.hedera.node.config.Utils;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.HooksConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.InstantSource;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.status.PlatformStatus;

@Singleton
public final class IngestChecker {
    private static final Logger logger = LogManager.getLogger(IngestChecker.class);
    private static final Set<HederaFunctionality> FEATURE_FLAGGED_TRANSACTIONS = EnumSet.of(HederaFunctionality.LAMBDA_S_STORE, new HederaFunctionality[]{HederaFunctionality.CRYPTO_CREATE, HederaFunctionality.CONTRACT_CREATE, HederaFunctionality.CRYPTO_UPDATE, HederaFunctionality.CONTRACT_UPDATE, HederaFunctionality.CRYPTO_TRANSFER});
    private static final Set<HederaFunctionality> UNSUPPORTED_TRANSACTIONS = EnumSet.of(HederaFunctionality.CRYPTO_ADD_LIVE_HASH, HederaFunctionality.CRYPTO_DELETE_LIVE_HASH);
    private static final Set<HederaFunctionality> PRIVILEGED_TRANSACTIONS = EnumSet.of(HederaFunctionality.FREEZE, HederaFunctionality.SYSTEM_DELETE, HederaFunctionality.SYSTEM_UNDELETE);
    private final CurrentPlatformStatus currentPlatformStatus;
    private final BlockStreamManager blockStreamManager;
    private final TransactionChecker transactionChecker;
    private final SolvencyPreCheck solvencyPreCheck;
    private final SignatureVerifier signatureVerifier;
    private final SignatureExpander signatureExpander;
    private final DeduplicationCache deduplicationCache;
    private final TransactionDispatcher dispatcher;
    private final FeeManager feeManager;
    private final AccountID nodeAccount;
    private final Authorizer authorizer;
    private final SynchronizedThrottleAccumulator synchronizedThrottleAccumulator;
    private final InstantSource instantSource;
    private final OpWorkflowMetrics workflowMetrics;
    @Nullable
    private final AtomicBoolean systemEntitiesCreatedFlag;

    @Inject
    public IngestChecker(@NodeSelfId @NonNull AccountID nodeAccount, @NonNull CurrentPlatformStatus currentPlatformStatus, @NonNull BlockStreamManager blockStreamManager, @NonNull TransactionChecker transactionChecker, @NonNull SolvencyPreCheck solvencyPreCheck, @NonNull SignatureExpander signatureExpander, @NonNull SignatureVerifier signatureVerifier, @NonNull DeduplicationCache deduplicationCache, @NonNull TransactionDispatcher dispatcher, @NonNull FeeManager feeManager, @NonNull Authorizer authorizer, @NonNull SynchronizedThrottleAccumulator synchronizedThrottleAccumulator, @NonNull InstantSource instantSource, @NonNull OpWorkflowMetrics workflowMetrics, @Nullable AtomicBoolean systemEntitiesCreatedFlag) {
        this.nodeAccount = Objects.requireNonNull(nodeAccount, "nodeAccount must not be null");
        this.currentPlatformStatus = Objects.requireNonNull(currentPlatformStatus, "currentPlatformStatus must not be null");
        this.blockStreamManager = Objects.requireNonNull(blockStreamManager, "blockStreamManager must not be null");
        this.transactionChecker = Objects.requireNonNull(transactionChecker, "transactionChecker must not be null");
        this.solvencyPreCheck = Objects.requireNonNull(solvencyPreCheck, "solvencyPreCheck must not be null");
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier, "signatureVerifier must not be null");
        this.signatureExpander = Objects.requireNonNull(signatureExpander, "signatureExpander must not be null");
        this.deduplicationCache = Objects.requireNonNull(deduplicationCache, "deduplicationCache must not be null");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher must not be null");
        this.feeManager = Objects.requireNonNull(feeManager, "feeManager must not be null");
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer must not be null");
        this.synchronizedThrottleAccumulator = Objects.requireNonNull(synchronizedThrottleAccumulator, "synchronizedThrottleAccumulator must not be null");
        this.instantSource = Objects.requireNonNull(instantSource, "instantSource must not be null");
        this.workflowMetrics = Objects.requireNonNull(workflowMetrics, "workflowMetrics must not be null");
        this.systemEntitiesCreatedFlag = systemEntitiesCreatedFlag;
    }

    public void verifyPlatformActive() throws PreCheckException {
        if (this.currentPlatformStatus.get() != PlatformStatus.ACTIVE) {
            throw new PreCheckException(ResponseCodeEnum.PLATFORM_NOT_ACTIVE);
        }
    }

    public void verifyReadyForTransactions() throws PreCheckException {
        this.verifyPlatformActive();
        if (this.systemEntitiesCreatedFlag != null && !this.systemEntitiesCreatedFlag.get()) {
            throw new PreCheckException(ResponseCodeEnum.CREATING_SYSTEM_ENTITIES);
        }
        if (!this.blockStreamManager.hasLedgerId()) {
            throw new PreCheckException(ResponseCodeEnum.WAITING_FOR_LEDGER_ID);
        }
    }

    public void runAllChecks(@NonNull State state, @NonNull Bytes serializedTransaction, @NonNull Configuration configuration, @NonNull Result result) throws PreCheckException {
        this.runAllChecks(state, serializedTransaction, configuration, result, InnerTransaction.NO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAllChecks(@NonNull State state, @NonNull Bytes serializedTransaction, @NonNull Configuration configuration, @NonNull Result result, @NonNull InnerTransaction innerTransaction) throws PreCheckException {
        TransactionInfo txInfo;
        Objects.requireNonNull(result);
        Instant consensusTime = this.instantSource.instant();
        int maxBytes = Utils.maxIngestParseSize((Configuration)configuration);
        if (innerTransaction == InnerTransaction.YES) {
            txInfo = this.transactionChecker.parseSignedAndCheck(serializedTransaction, maxBytes);
        } else {
            txInfo = this.transactionChecker.parseAndCheck(serializedTransaction, maxBytes);
            result.setTxnInfo(txInfo);
        }
        this.transactionChecker.checkJumboTransactionBody(txInfo);
        TransactionBody txBody = txInfo.txBody();
        HederaFunctionality functionality = txInfo.functionality();
        if (!this.nodeAccount.equals((Object)txBody.nodeAccountID()) && innerTransaction == InnerTransaction.NO) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_NODE_ACCOUNT);
        }
        this.transactionChecker.checkTimeBox(txBody, consensusTime, TransactionChecker.RequireMinValidLifetimeBuffer.YES);
        assert (functionality != HederaFunctionality.NONE);
        if (this.deduplicationCache.contains(txInfo.transactionID())) {
            throw new PreCheckException(ResponseCodeEnum.DUPLICATE_TRANSACTION);
        }
        try {
            this.checkThrottles(txInfo, state, configuration, result.throttleUsages());
        }
        finally {
            result.setThrottleUsages(result.throttleUsages());
        }
        PureChecksContextImpl pureChecksContext = new PureChecksContextImpl(txBody, this.dispatcher);
        this.dispatcher.dispatchPureChecks(pureChecksContext);
        ReadableStoreFactory storeFactory = new ReadableStoreFactory(state);
        Account payer = this.solvencyPreCheck.getPayerAccount(storeFactory, txInfo.payerID());
        Key payerKey = payer.key();
        if (payerKey == null) {
            logger.warn("Payer account {} has no key, indicating a problem with state", (Object)txInfo.payerID());
            throw new PreCheckException(ResponseCodeEnum.UNAUTHORIZED);
        }
        this.verifyPayerSignature(txInfo, payer, configuration);
        int numSigs = txInfo.signatureMap().sigPair().size();
        FeeContextImpl feeContext = new FeeContextImpl(consensusTime, txInfo, payerKey, txInfo.payerID(), this.feeManager, storeFactory, configuration, this.authorizer, numSigs, this.dispatcher);
        Fees fees = this.dispatcher.dispatchComputeFees(feeContext);
        this.solvencyPreCheck.checkSolvency(txInfo, payer, fees, DispatchValidator.WorkflowCheck.INGEST);
        if (functionality == HederaFunctionality.ATOMIC_BATCH) {
            for (Bytes bytes : txBody.atomicBatch().transactions()) {
                this.runAllChecks(state, bytes, configuration, result, InnerTransaction.YES);
            }
        }
    }

    private void checkThrottles(@NonNull TransactionInfo txInfo, @NonNull State state, @NonNull Configuration configuration, @NonNull List<ThrottleUsage> throttleUsages) throws PreCheckException {
        HederaConfig hederaConfig = (HederaConfig)configuration.getConfigData(HederaConfig.class);
        HooksConfig hooksConfig = (HooksConfig)configuration.getConfigData(HooksConfig.class);
        this.assertThrottlingPreconditions(txInfo, hederaConfig, hooksConfig);
        if (hederaConfig.ingestThrottleEnabled() && this.synchronizedThrottleAccumulator.shouldThrottle(txInfo, state, throttleUsages)) {
            this.workflowMetrics.incrementThrottled(txInfo.functionality());
            throw new PreCheckException(ResponseCodeEnum.BUSY);
        }
    }

    private void assertThrottlingPreconditions(@NonNull TransactionInfo txInfo, @NonNull HederaConfig hederaConfig, @NonNull HooksConfig hooksConfig) throws PreCheckException {
        HederaFunctionality function = txInfo.functionality();
        if (UNSUPPORTED_TRANSACTIONS.contains(function)) {
            throw new PreCheckException(ResponseCodeEnum.NOT_SUPPORTED);
        }
        if (PRIVILEGED_TRANSACTIONS.contains(function)) {
            long payerNum;
            long l = payerNum = txInfo.payerID() == null ? Long.MAX_VALUE : txInfo.payerID().accountNumOrElse(Long.valueOf(Long.MAX_VALUE));
            if (payerNum >= hederaConfig.firstUserEntity()) {
                throw new PreCheckException(ResponseCodeEnum.NOT_SUPPORTED);
            }
        }
        if (FEATURE_FLAGGED_TRANSACTIONS.contains(function) && !hooksConfig.hooksEnabled()) {
            switch (function) {
                case LAMBDA_S_STORE: {
                    throw new PreCheckException(ResponseCodeEnum.HOOKS_NOT_ENABLED);
                }
                case CRYPTO_CREATE: {
                    PreCheckException.validateTruePreCheck((boolean)txInfo.txBody().cryptoCreateAccountOrThrow().hookCreationDetails().isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
                    break;
                }
                case CONTRACT_CREATE: {
                    PreCheckException.validateTruePreCheck((boolean)txInfo.txBody().contractCreateInstanceOrThrow().hookCreationDetails().isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
                    break;
                }
                case CRYPTO_UPDATE: {
                    CryptoUpdateTransactionBody op = txInfo.txBody().cryptoUpdateAccountOrThrow();
                    PreCheckException.validateTruePreCheck((op.hookIdsToDelete().isEmpty() && op.hookCreationDetails().isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
                    break;
                }
                case CONTRACT_UPDATE: {
                    ContractUpdateTransactionBody op = txInfo.txBody().contractUpdateInstanceOrThrow();
                    PreCheckException.validateTruePreCheck((op.hookIdsToDelete().isEmpty() && op.hookCreationDetails().isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
                    break;
                }
                case CRYPTO_TRANSFER: {
                    CryptoTransferTransactionBody op = txInfo.txBody().cryptoTransferOrThrow();
                    for (AccountAmount adjust : op.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
                        PreCheckException.validateFalsePreCheck((adjust.hasPreTxAllowanceHook() || adjust.hasPrePostTxAllowanceHook() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
                    }
                    for (TokenTransferList tokenTransfers : op.tokenTransfers()) {
                        for (AccountAmount adjust : tokenTransfers.transfers()) {
                            PreCheckException.validateFalsePreCheck((adjust.hasPreTxAllowanceHook() || adjust.hasPrePostTxAllowanceHook() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
                        }
                        for (NftTransfer nftTransfer : tokenTransfers.nftTransfers()) {
                            PreCheckException.validateFalsePreCheck((nftTransfer.hasPreTxSenderAllowanceHook() || nftTransfer.hasPrePostTxSenderAllowanceHook() || nftTransfer.hasPreTxReceiverAllowanceHook() || nftTransfer.hasPrePostTxReceiverAllowanceHook() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
                        }
                    }
                    break;
                }
            }
        }
    }

    private void verifyPayerSignature(@NonNull TransactionInfo txInfo, @NonNull Account payer, @NonNull Configuration configuration) throws PreCheckException {
        Key payerKey = payer.key();
        HederaConfig hederaConfig = (HederaConfig)configuration.getConfigData(HederaConfig.class);
        List sigPairs = txInfo.signatureMap().sigPair();
        HashSet<ExpandedSignaturePair> expandedSigs = new HashSet<ExpandedSignaturePair>();
        this.signatureExpander.expand(sigPairs, expandedSigs);
        if (!HapiUtils.isHollow((Account)payer)) {
            this.signatureExpander.expand(payerKey, (List<SignaturePair>)sigPairs, expandedSigs);
        } else {
            Optional<SignaturePair> originals = txInfo.signatureMap().sigPair().stream().filter(SignaturePair::hasEcdsaSecp256k1).filter(pair -> Bytes.wrap((byte[])EthSigsUtils.recoverAddressFromPubKey((byte[])pair.pubKeyPrefix().toByteArray())).equals((Object)payer.alias())).findFirst();
            PreCheckException.validateTruePreCheck((boolean)originals.isPresent(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_SIGNATURE);
            this.signatureExpander.expand(List.of(originals.get()), expandedSigs);
        }
        Map<Key, SignatureVerificationFuture> results = this.signatureVerifier.verify(txInfo.signedBytes(), expandedSigs);
        DefaultKeyVerifier verifier = new DefaultKeyVerifier(hederaConfig, results);
        SignatureVerification payerKeyVerification = !HapiUtils.isHollow((Account)payer) ? verifier.verificationFor(payerKey) : verifier.verificationFor(payer.alias());
        if (payerKeyVerification.failed()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_SIGNATURE);
        }
    }

    public static class Result {
        @Nullable
        private TransactionInfo txnInfo;
        private List<ThrottleUsage> throttleUsages = new ArrayList<ThrottleUsage>();

        @NonNull
        public TransactionInfo txnInfoOrThrow() {
            return Objects.requireNonNull(this.txnInfo);
        }

        public void setTxnInfo(@Nullable TransactionInfo txnInfo) {
            this.txnInfo = txnInfo;
        }

        @NonNull
        public List<ThrottleUsage> throttleUsages() {
            return this.throttleUsages;
        }

        public void setThrottleUsages(@Nullable List<ThrottleUsage> throttleUsages) {
            this.throttleUsages = throttleUsages;
        }
    }
}

