/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.TypeName;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.GlobalServiceRegistry;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Services {
    private Services() {
    }

    public static void registry(ServiceRegistry registry) {
        GlobalServiceRegistry.registry(registry);
    }

    @SafeVarargs
    public static <T> void set(Class<T> contract, T ... instances) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(instances);
        for (T instance : instances) {
            Objects.requireNonNull(instance, "All instances must be non-null");
        }
        ServiceRegistry registry = GlobalServiceRegistry.registry();
        if (registry instanceof CoreServiceRegistry) {
            CoreServiceRegistry csr = (CoreServiceRegistry)registry;
            csr.set(contract, instances);
        }
    }

    public static <T> void add(Class<T> contract, double weight, T instance) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(instance);
        ServiceRegistry registry = GlobalServiceRegistry.registry();
        if (registry instanceof CoreServiceRegistry) {
            CoreServiceRegistry csr = (CoreServiceRegistry)registry;
            csr.add(contract, weight, instance);
        }
    }

    public static void add(ServiceDescriptor<?> descriptor) {
        Objects.requireNonNull(descriptor);
        ServiceRegistry registry = GlobalServiceRegistry.registry();
        if (registry instanceof CoreServiceRegistry) {
            CoreServiceRegistry csr = (CoreServiceRegistry)registry;
            csr.add(descriptor);
        }
    }

    public static <T> T get(Class<T> contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().get(contract);
    }

    public static <T> T get(TypeName contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().get(contract);
    }

    public static <T> List<T> all(Class<T> contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().all(contract);
    }

    public static <T> List<T> all(TypeName contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().all(contract);
    }

    public static <T> Optional<T> first(Class<T> contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().first(contract);
    }

    public static <T> Optional<T> first(TypeName contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().first(contract);
    }
}

