/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl;

import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.consensus.impl.ReadableTopicStoreImpl;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;

public class WritableTopicStore
extends ReadableTopicStoreImpl {
    private final WritableEntityCounters entityCounters;

    public WritableTopicStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.entityCounters = entityCounters;
    }

    protected WritableKVState<TopicID, Topic> topicState() {
        return (WritableKVState)super.topicState();
    }

    public void put(@NonNull Topic topic) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(topic.topicId());
        this.topicState().put((Object)topic.topicId(), (Object)topic);
    }

    public void putAndIncrementCount(@NonNull Topic topic) {
        this.put(topic);
        this.entityCounters.incrementEntityTypeCount(EntityType.TOPIC);
    }

    public Topic get(@NonNull TopicID topicID) {
        Objects.requireNonNull(topicID);
        return (Topic)this.topicState().get((Object)topicID);
    }

    public Set<TopicID> modifiedTopics() {
        return this.topicState().modifiedKeys();
    }
}

