/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.node.app.service.file.ReadableUpgradeFileStore;
import com.hedera.node.app.service.file.impl.schemas.V0490FileSchema;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;

public class ReadableUpgradeFileStoreImpl
implements ReadableUpgradeFileStore {
    private final ReadableStates states;
    private final ReadableKVState<FileID, File> upgradeFileState;

    public ReadableUpgradeFileStoreImpl(@NonNull ReadableStates states) {
        this.states = Objects.requireNonNull(states);
        this.upgradeFileState = Objects.requireNonNull(states.get(V0490FileSchema.FILES_STATE_ID));
    }

    @Nullable
    public File peek(FileID fileID) {
        return (File)this.upgradeFileState.get((Object)fileID);
    }

    @NonNull
    public Bytes getFull(FileID fileID) throws IOException {
        Bytes fullContents;
        ByteArrayOutputStream collector = new ByteArrayOutputStream();
        String stateKey = "FileService_I_UPGRADE_DATA_%d".formatted(fileID.fileNum()).toUpperCase();
        int stateId = SingletonType.valueOf((String)stateKey).protoOrdinal();
        ReadableQueueState upgradeState = Objects.requireNonNull(this.states.getQueue(stateId));
        if (this.upgradeFileState.get((Object)fileID) != null) {
            for (ProtoBytes file : upgradeState) {
                collector.write(file.value().toByteArray());
            }
            fullContents = Bytes.wrap((byte[])collector.toByteArray());
        } else {
            fullContents = Bytes.EMPTY;
        }
        return fullContents;
    }
}

