/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.handlers;

import com.google.protobuf.ByteString;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.FileUpdateTransactionBody;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.file.ExtantFileContext;
import com.hedera.node.app.hapi.fees.usage.file.FileOpsUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.service.file.FileSignatureWaivers;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.file.impl.WritableFileStore;
import com.hedera.node.app.service.file.impl.WritableUpgradeFileStore;
import com.hedera.node.app.service.file.impl.utils.FileServiceUtils;
import com.hedera.node.app.spi.authorization.SystemPrivilege;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.types.LongPair;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.KeyList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileUpdateHandler
implements TransactionHandler {
    private static final Timestamp EXPIRE_NEVER = Timestamp.newBuilder().seconds(0x7FFFFFFFFFFFFFFEL).build();
    private final FileOpsUsage fileOpsUsage;
    private final FileSignatureWaivers fileSignatureWaivers;

    @Inject
    public FileUpdateHandler(FileOpsUsage fileOpsUsage, FileSignatureWaivers fileSignatureWaivers) {
        this.fileOpsUsage = fileOpsUsage;
        this.fileSignatureWaivers = fileSignatureWaivers;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        FileUpdateTransactionBody transactionBody = txn.fileUpdateOrThrow();
        if (transactionBody.fileID() == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_FILE_ID);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody body = context.body();
        FileUpdateTransactionBody op = body.fileUpdateOrThrow();
        ReadableFileStore fileStore = (ReadableFileStore)context.createStore(ReadableFileStore.class);
        FileID transactionFileId = Objects.requireNonNull(op.fileID());
        FileServiceUtils.preValidate(transactionFileId, fileStore, context);
        boolean areSignaturesWaived = this.fileSignatureWaivers.areFileUpdateSignaturesWaived(body, context.payer());
        if (areSignaturesWaived) {
            return;
        }
        File file = fileStore.getFileLeaf(transactionFileId);
        if (FileUpdateHandler.wantsToMutateNonExpiryField(op)) {
            FileServiceUtils.validateAndAddRequiredKeys(file, op.keys(), context);
        }
    }

    public void handle(@NonNull HandleContext handleContext) throws HandleException {
        Objects.requireNonNull(handleContext);
        WritableFileStore fileStore = (WritableFileStore)handleContext.storeFactory().writableStore(WritableFileStore.class);
        FileUpdateTransactionBody fileUpdate = handleContext.body().fileUpdateOrThrow();
        FilesConfig fileServiceConfig = (FilesConfig)handleContext.configuration().getConfigData(FilesConfig.class);
        if (fileUpdate.fileID() == null) {
            throw new HandleException(ResponseCodeEnum.INVALID_FILE_ID);
        }
        FileID fileID = fileUpdate.fileIDOrThrow();
        LongPair upgradeFileRange = fileServiceConfig.softwareUpdateRange();
        if (fileID.fileNum() >= upgradeFileRange.left() && fileID.fileNum() <= upgradeFileRange.right()) {
            this.handleUpdateUpgradeFile(fileUpdate, handleContext);
            return;
        }
        Optional<File> maybeFile = fileStore.get(fileUpdate.fileIDOrElse(FileID.DEFAULT));
        if (maybeFile.isEmpty()) {
            throw new HandleException(ResponseCodeEnum.INVALID_FILE_ID);
        }
        File file = maybeFile.get();
        HandleException.validateFalse((boolean)file.deleted(), (ResponseCodeEnum)ResponseCodeEnum.FILE_DELETED);
        if (FileUpdateHandler.wantsToMutateNonExpiryField(fileUpdate)) {
            if (handleContext.hasPrivilegedAuthorization() != SystemPrivilege.AUTHORIZED) {
                HandleException.validateTrue((file.hasKeys() && !file.keys().keys().isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.UNAUTHORIZED);
            }
            this.validateMaybeNewMemo(handleContext.attributeValidator(), fileUpdate);
        }
        this.validateAutoRenew(fileUpdate, handleContext);
        File.Builder builder = new File.Builder();
        builder.fileId(file.fileId());
        builder.deleted(file.deleted());
        AccountsConfig accountsConfig = (AccountsConfig)handleContext.configuration().getConfigData(AccountsConfig.class);
        this.resolveMutableBuilderAttributes(fileUpdate, builder, fileServiceConfig, file, fileID, accountsConfig, handleContext.payer());
        fileStore.put(builder.build());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody op = feeContext.body();
        File file = ((ReadableFileStore)feeContext.readableStore(ReadableFileStore.class)).getFileLeaf(op.fileUpdateOrThrow().fileIDOrThrow());
        AccountID payerId = op.transactionID().accountID();
        SystemPrivilege privilege = feeContext.authorizer().hasPrivilegedAuthorization(payerId, HederaFunctionality.FILE_UPDATE, op);
        if (privilege != SystemPrivilege.UNNECESSARY) {
            return Fees.FREE;
        }
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)op), (SigValueObj)sigValueObj, CommonPbjConverters.fromPbj((File)file)));
    }

    private void handleUpdateUpgradeFile(FileUpdateTransactionBody fileUpdate, HandleContext handleContext) {
        WritableUpgradeFileStore fileStore = (WritableUpgradeFileStore)handleContext.storeFactory().writableStore(WritableUpgradeFileStore.class);
        FileID fileId = fileUpdate.fileIDOrThrow();
        if (fileUpdate.contents() != null && fileUpdate.contents().length() > 0L) {
            fileStore.resetFileContents(fileId);
            fileStore.addUpgradeContent(fileId, fileUpdate.contents());
        }
        File file = new File.Builder().fileId(fileId).deleted(false).expirationSecond(fileUpdate.expirationTimeOrElse(EXPIRE_NEVER).seconds()).build();
        fileStore.add(file);
    }

    private void resolveMutableBuilderAttributes(@NonNull FileUpdateTransactionBody op, @NonNull File.Builder builder, @NonNull FilesConfig filesConfig, @NonNull File file, @NonNull FileID fileId, @NonNull AccountsConfig accountsConfig, @NonNull AccountID payerId) {
        boolean zeroLengthShouldClearTarget;
        if (op.hasKeys()) {
            builder.keys(op.keys());
        } else {
            builder.keys(file.keys());
        }
        long contentLength = op.contents().length();
        boolean bl = zeroLengthShouldClearTarget = accountsConfig.isSuperuser(payerId) && filesConfig.isOverrideFile(fileId);
        if (contentLength > 0L || zeroLengthShouldClearTarget) {
            if (contentLength > (long)filesConfig.maxSizeKb() * 1024L) {
                throw new HandleException(ResponseCodeEnum.MAX_FILE_SIZE_EXCEEDED);
            }
            builder.contents(op.contents());
        } else {
            builder.contents(file.contents());
        }
        if (op.hasMemo()) {
            builder.memo(op.memo());
        } else {
            builder.memo(file.memo());
        }
        if (op.hasExpirationTime() && op.expirationTime().seconds() > file.expirationSecond()) {
            builder.expirationSecond(op.expirationTime().seconds());
        } else {
            builder.expirationSecond(file.expirationSecond());
        }
    }

    private void validateAutoRenew(FileUpdateTransactionBody op, HandleContext handleContext) {
        if (op.hasExpirationTime()) {
            HandleContext.TransactionCategory category = handleContext.savepointStack().getBaseBuilder(StreamBuilder.class).category();
            boolean isInternalDispatch = category == HandleContext.TransactionCategory.CHILD || category == HandleContext.TransactionCategory.PRECEDING;
            long startSeconds = isInternalDispatch ? handleContext.consensusNow().getEpochSecond() : handleContext.body().transactionID().transactionValidStart().seconds();
            long effectiveDuration = op.expirationTime().seconds() - startSeconds;
            LedgerConfig ledgerConfig = (LedgerConfig)handleContext.configuration().getConfigData(LedgerConfig.class);
            long maxEntityLifetime = ledgerConfig.autoRenewPeriodMaxDuration();
            long minEntityLifetime = ledgerConfig.autoRenewPeriodMinDuration();
            HandleException.validateTrue((effectiveDuration >= minEntityLifetime && effectiveDuration <= maxEntityLifetime ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.AUTORENEW_DURATION_NOT_IN_RANGE);
        }
    }

    public static boolean wantsToMutateNonExpiryField(@NonNull FileUpdateTransactionBody op) {
        return op.hasMemo() || op.hasKeys() || op.contents().length() > 0L;
    }

    private void validateMaybeNewMemo(@NonNull AttributeValidator attributeValidator, @NonNull FileUpdateTransactionBody op) {
        if (op.hasMemo()) {
            attributeValidator.validateMemo(op.memo());
        }
    }

    private FeeData usageGiven(com.hederahashgraph.api.proto.java.TransactionBody txn, SigValueObj svo, com.hederahashgraph.api.proto.java.File file) {
        SigUsage sigUsage = new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount());
        if (file != null) {
            ByteString contents = file.getContents();
            ExtantFileContext ctx = ExtantFileContext.newBuilder().setCurrentSize(contents == null ? 0L : (long)contents.size()).setCurrentWacl(file.getKeys()).setCurrentMemo(file.getMemo()).setCurrentExpiry(file.getExpirationSecond()).build();
            return this.fileOpsUsage.fileUpdateUsage(txn, sigUsage, ctx);
        }
        long now = txn.getTransactionID().getTransactionValidStart().getSeconds();
        return this.fileOpsUsage.fileUpdateUsage(txn, sigUsage, FileUpdateHandler.missingCtx(now));
    }

    static ExtantFileContext missingCtx(long now) {
        return ExtantFileContext.newBuilder().setCurrentExpiry(now).setCurrentMemo("").setCurrentWacl(KeyList.getDefaultInstance()).setCurrentSize(0L).build();
    }
}

