/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.crypto;

import com.google.common.base.MoreObjects;
import com.hederahashgraph.api.proto.java.CryptoDeleteAllowanceTransactionBody;
import com.hederahashgraph.api.proto.java.NftRemoveAllowance;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CryptoDeleteAllowanceMeta {
    private final long effectiveNow;
    private final long msgBytesUsed;

    public CryptoDeleteAllowanceMeta(Builder builder) {
        this.effectiveNow = builder.effectiveNow;
        this.msgBytesUsed = builder.msgBytesUsed;
    }

    public CryptoDeleteAllowanceMeta(CryptoDeleteAllowanceTransactionBody cryptoDeleteTxnBody, long transactionValidStartSecs) {
        this.effectiveNow = transactionValidStartSecs;
        this.msgBytesUsed = this.bytesUsedInTxn(cryptoDeleteTxnBody);
    }

    private int bytesUsedInTxn(CryptoDeleteAllowanceTransactionBody op) {
        return op.getNftAllowancesCount() * 48 + CryptoDeleteAllowanceMeta.countNftDeleteSerials(op.getNftAllowancesList()) * 8;
    }

    public static int countNftDeleteSerials(List<NftRemoveAllowance> nftAllowancesList) {
        int totalSerials = 0;
        for (NftRemoveAllowance allowance : nftAllowancesList) {
            totalSerials += allowance.getSerialNumbersCount();
        }
        return totalSerials;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getEffectiveNow() {
        return this.effectiveNow;
    }

    public long getMsgBytesUsed() {
        return this.msgBytesUsed;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("effectiveNow", this.effectiveNow).add("msgBytesUsed", this.msgBytesUsed).toString();
    }

    public static class Builder {
        private long effectiveNow;
        private long msgBytesUsed;

        public Builder effectiveNow(long now) {
            this.effectiveNow = now;
            return this;
        }

        public Builder msgBytesUsed(long msgBytesUsed) {
            this.msgBytesUsed = msgBytesUsed;
            return this;
        }

        public CryptoDeleteAllowanceMeta build() {
            return new CryptoDeleteAllowanceMeta(this);
        }
    }
}

