/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.Supplier;

public class PlatformFunctionGauge<T>
extends AbstractMetric
implements FunctionGauge<T> {
    private final Metric.DataType dataType;
    private final Supplier<T> supplier;

    public PlatformFunctionGauge(@NonNull FunctionGauge.Config<T> config) {
        super(config);
        this.dataType = MetricConfig.mapDataType(config.getType());
        this.supplier = config.getSupplier();
    }

    @NonNull
    public Metric.DataType getDataType() {
        return this.dataType;
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.get()));
    }

    @Override
    public T get() {
        return this.supplier.get();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", this.supplier.get()).toString();
    }
}

