/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.CryptoSignatureWaivers;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.authorization.SystemPrivilege;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoSignatureWaiversImpl
implements CryptoSignatureWaivers {
    private final Authorizer authorizer;

    @Inject
    public CryptoSignatureWaiversImpl(@NonNull Authorizer authorizer) {
        this.authorizer = Objects.requireNonNull(authorizer);
    }

    public boolean isTargetAccountSignatureWaived(TransactionBody cryptoUpdateTxn, AccountID payer) {
        return this.authorizer.hasPrivilegedAuthorization(payer, HederaFunctionality.CRYPTO_UPDATE, cryptoUpdateTxn) == SystemPrivilege.AUTHORIZED;
    }

    public boolean isNewKeySignatureWaived(TransactionBody cryptoUpdateTxn, AccountID payer) {
        boolean isAuthorized;
        boolean bl = isAuthorized = this.authorizer.hasPrivilegedAuthorization(payer, HederaFunctionality.CRYPTO_UPDATE, cryptoUpdateTxn) == SystemPrivilege.AUTHORIZED;
        if (!isAuthorized) {
            return false;
        }
        AccountID targetNum = cryptoUpdateTxn.cryptoUpdateAccountOrThrow().accountIDToUpdateOrThrow();
        return !this.authorizer.isTreasury(targetNum);
    }
}

