/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.common.EntityIDPair;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.impl.schemas.V0490TokenSchema;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReadableTokenRelationStoreImpl
implements ReadableTokenRelationStore {
    private final ReadableKVState<EntityIDPair, TokenRelation> readableTokenRelState;
    private final ReadableEntityCounters entityCounters;

    public ReadableTokenRelationStoreImpl(@NonNull ReadableStates states, @NonNull ReadableEntityCounters entityCounters) {
        this.readableTokenRelState = Objects.requireNonNull(states).get(V0490TokenSchema.TOKEN_RELS_STATE_ID);
        this.entityCounters = Objects.requireNonNull(entityCounters);
    }

    @Nullable
    public TokenRelation get(@NonNull AccountID accountId, @NonNull TokenID tokenId) {
        Objects.requireNonNull(accountId);
        Objects.requireNonNull(tokenId);
        if (AccountID.DEFAULT.equals((Object)accountId) || TokenID.DEFAULT.equals((Object)tokenId)) {
            return null;
        }
        return (TokenRelation)this.readableTokenRelState.get((Object)EntityIDPair.newBuilder().accountId(accountId).tokenId(tokenId).build());
    }

    public long sizeOfState() {
        return this.entityCounters.getCounterFor(EntityType.TOKEN_ASSOCIATION);
    }

    public void warm(@NonNull AccountID accountID, @NonNull TokenID tokenId) {
        EntityIDPair key = EntityIDPair.newBuilder().accountId(accountID).tokenId(tokenId).build();
        this.readableTokenRelState.warm((Object)key);
    }
}

