/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.token.impl.ReadableTokenStoreImpl;
import com.hedera.node.app.service.token.impl.schemas.V0490TokenSchema;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Set;

public class WritableTokenStore
extends ReadableTokenStoreImpl {
    private final WritableKVState<TokenID, Token> tokenState;
    private final WritableEntityCounters entityCounters;

    public WritableTokenStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.tokenState = states.get(V0490TokenSchema.TOKENS_STATE_ID);
        this.entityCounters = entityCounters;
    }

    public void put(@NonNull Token token) {
        Objects.requireNonNull(token);
        WritableTokenStore.requireNotDefault(token.tokenId());
        this.tokenState.put((Object)token.tokenId(), (Object)Objects.requireNonNull(token));
    }

    public void putAndIncrementCount(@NonNull Token token) {
        this.put(token);
        this.entityCounters.incrementEntityTypeCount(EntityType.TOKEN);
    }

    @Override
    public long sizeOfState() {
        return this.entityCounters.getCounterFor(EntityType.TOKEN);
    }

    @NonNull
    public Set<TokenID> modifiedTokens() {
        return this.tokenState.modifiedKeys();
    }

    @Nullable
    public Token getOriginalValue(@NonNull TokenID tokenId) {
        Objects.requireNonNull(tokenId);
        return (Token)this.tokenState.getOriginalValue((Object)tokenId);
    }

    public static void requireNotDefault(@NonNull TokenID tokenId) {
        if (tokenId.equals((Object)TokenID.DEFAULT)) {
            throw new IllegalArgumentException("Token ID cannot be default");
        }
    }
}

