/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.util.TokenKey;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.TokensConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseTokenHandler {
    private static final Logger log = LogManager.getLogger(BaseTokenHandler.class);
    protected static final Set<TokenKey> NON_ADMIN_TOKEN_KEYS = EnumSet.complementOf(EnumSet.of(TokenKey.ADMIN_KEY));
    protected static final Set<TokenKey> TOKEN_KEYS = EnumSet.allOf(TokenKey.class);
    public static final int UNLIMITED_AUTOMATIC_ASSOCIATIONS = -1;

    protected long mintFungible(@NonNull Token token, @NonNull TokenRelation treasuryRel, long amount, @NonNull WritableAccountStore accountStore, @NonNull WritableTokenStore tokenStore, @NonNull WritableTokenRelationStore tokenRelationStore, @NonNull ExpiryValidator expiryValidator) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(treasuryRel);
        return this.changeSupply(token, treasuryRel, amount, ResponseCodeEnum.INVALID_TOKEN_MINT_AMOUNT, accountStore, tokenStore, tokenRelationStore, expiryValidator);
    }

    protected long changeSupply(@NonNull Token token, @NonNull TokenRelation treasuryRel, long amount, @NonNull ResponseCodeEnum invalidSupplyCode, @NonNull WritableAccountStore accountStore, @NonNull WritableTokenStore tokenStore, @NonNull WritableTokenRelationStore tokenRelationStore, @NonNull ExpiryValidator expiryValidator) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(treasuryRel);
        Objects.requireNonNull(invalidSupplyCode);
        HandleException.validateTrue((treasuryRel.accountId().equals((Object)token.treasuryAccountId()) && token.tokenId().equals((Object)treasuryRel.tokenId()) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FAIL_INVALID);
        long newTotalSupply = token.totalSupply() + amount;
        HandleException.validateTrue((newTotalSupply >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)invalidSupplyCode);
        if (token.supplyType() == TokenSupplyType.FINITE) {
            HandleException.validateTrue((token.maxSupply() >= newTotalSupply ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_MAX_SUPPLY_REACHED);
        }
        Account treasuryAccount = TokenHandlerHelper.getIfUsable(treasuryRel.accountId(), accountStore, expiryValidator, ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN);
        long newTreasuryBalance = treasuryRel.balance() + amount;
        HandleException.validateTrue((newTreasuryBalance >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_TOKEN_BALANCE);
        Account.Builder copyTreasuryAccount = treasuryAccount.copyBuilder();
        Token.Builder copyToken = token.copyBuilder();
        TokenRelation.Builder copyTreasuryRel = treasuryRel.copyBuilder();
        if (treasuryRel.balance() == 0L && amount > 0L) {
            copyTreasuryAccount.numberPositiveBalances(treasuryAccount.numberPositiveBalances() + 1);
        } else if (newTreasuryBalance == 0L && amount < 0L) {
            copyTreasuryAccount.numberPositiveBalances(treasuryAccount.numberPositiveBalances() - 1);
        }
        copyToken.totalSupply(newTotalSupply);
        copyTreasuryRel.balance(newTreasuryBalance);
        accountStore.put(copyTreasuryAccount.build());
        tokenStore.put(copyToken.build());
        tokenRelationStore.put(copyTreasuryRel.build());
        return newTotalSupply;
    }

    protected void createAndLinkTokenRels(@NonNull Account account, @NonNull List<Token> tokens, @NonNull WritableAccountStore accountStore, @NonNull WritableTokenRelationStore tokenRelStore) {
        List<TokenRelation> newTokenRels = this.createTokenRelsToAccount(account, tokens);
        if (!newTokenRels.isEmpty()) {
            this.linkTokenRels(account, newTokenRels, tokenRelStore);
            TokenRelation firstOfNewTokenRels = newTokenRels.get(0);
            Account updatedAcct = account.copyBuilder().headTokenId(firstOfNewTokenRels.tokenId()).numberAssociations(account.numberAssociations() + newTokenRels.size()).build();
            accountStore.put(updatedAcct);
            newTokenRels.forEach(tokenRelStore::putAndIncrementCount);
        }
    }

    private void linkTokenRels(@NonNull Account account, @NonNull List<TokenRelation> newTokenRels, @NonNull WritableTokenRelationStore tokenRelStore) {
        TokenID currentHeadTokenNum = account.headTokenId();
        if (BaseTokenHandler.isValidTokenId(currentHeadTokenNum)) {
            TokenRelation headTokenRel = tokenRelStore.get(account.accountId(), currentHeadTokenNum);
            if (headTokenRel != null) {
                TokenRelation lastOfNewTokenRels = newTokenRels.remove(newTokenRels.size() - 1);
                TokenRelation headTokenAsNonHeadTokenRel = headTokenRel.copyBuilder().previousToken(lastOfNewTokenRels.tokenId()).build();
                newTokenRels.add(lastOfNewTokenRels.copyBuilder().nextToken(headTokenAsNonHeadTokenRel.tokenId()).build());
                tokenRelStore.put(headTokenAsNonHeadTokenRel);
            } else {
                AccountID accountId = account.accountId();
                log.error("Unable to get head tokenRel for account {}.{}.{}, token {}.{}.{}! Linked-list relations are likely in a bad state", (Object)accountId.shardNum(), (Object)accountId.realmNum(), (Object)accountId.accountNum(), (Object)currentHeadTokenNum.shardNum(), (Object)currentHeadTokenNum.realmNum(), (Object)currentHeadTokenNum.tokenNum());
            }
        }
    }

    private List<TokenRelation> createTokenRelsToAccount(@NonNull Account account, @NonNull List<Token> tokens) {
        ArrayList<TokenRelation> newTokenRels = new ArrayList<TokenRelation>();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            TokenID prevTokenId = null;
            TokenID nextTokenId = null;
            if (i - 1 >= 0) {
                prevTokenId = Optional.ofNullable(tokens.get(i - 1)).map(Token::tokenId).orElse(null);
            }
            if (i + 1 < tokens.size()) {
                nextTokenId = Optional.ofNullable(tokens.get(i + 1)).map(Token::tokenId).orElse(null);
            }
            boolean isTreasuryAccount = Objects.equals(token.treasuryAccountId(), account.accountId());
            boolean isFrozen = token.hasFreezeKey() && token.accountsFrozenByDefault() && !isTreasuryAccount;
            boolean kycGranted = !token.hasKycKey() || isTreasuryAccount;
            TokenRelation newTokenRel = new TokenRelation(token.tokenId(), account.accountId(), 0L, isFrozen, kycGranted, false, prevTokenId, nextTokenId);
            newTokenRels.add(newTokenRel);
        }
        return newTokenRels;
    }

    protected TokenRelation autoAssociate(@NonNull AccountID accountId, @NonNull Token token, @NonNull WritableAccountStore accountStore, @NonNull WritableTokenRelationStore tokenRelStore, @NonNull Configuration config) {
        TokenRelation existingFirstTokenRel;
        TokensConfig tokensConfig = (TokensConfig)config.getConfigData(TokensConfig.class);
        EntitiesConfig entitiesConfig = (EntitiesConfig)config.getConfigData(EntitiesConfig.class);
        TokenID tokenId = token.tokenIdOrThrow();
        TokenRelation existingRel = tokenRelStore.get(accountId, tokenId);
        HandleException.validateTrue((existingRel == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT);
        HandleException.validateTrue((tokenRelStore.sizeOfState() + 1L < tokensConfig.maxAggregateRels() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        Account account = accountStore.get(accountId);
        int numAssociations = account.numberAssociations();
        HandleException.validateFalse((entitiesConfig.limitTokenAssociations() && numAssociations >= tokensConfig.maxPerAccount() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED);
        int maxAutoAssociations = account.maxAutoAssociations();
        int usedAutoAssociations = account.usedAutoAssociations();
        if (!BaseTokenHandler.hasUnlimitedAutoAssociations(account, entitiesConfig)) {
            HandleException.validateFalse((usedAutoAssociations >= maxAutoAssociations ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NO_REMAINING_AUTOMATIC_ASSOCIATIONS);
        }
        TokenRelation newTokenRel = TokenRelation.newBuilder().tokenId(tokenId).accountId(accountId).automaticAssociation(true).kycGranted(!token.hasKycKey()).frozen(token.hasFreezeKey() && token.accountsFrozenByDefault()).previousToken((TokenID)null).nextToken(account.headTokenId()).build();
        Account copyAccount = account.copyBuilder().numberAssociations(numAssociations + 1).usedAutoAssociations(usedAutoAssociations + 1).headTokenId(tokenId).build();
        TokenID existingFirstTokenId = account.headTokenId();
        if (existingFirstTokenId != null && (existingFirstTokenRel = tokenRelStore.get(accountId, existingFirstTokenId)) != null) {
            tokenRelStore.put(existingFirstTokenRel.copyBuilder().previousToken(tokenId).build());
        }
        accountStore.put(copyAccount);
        tokenRelStore.putAndIncrementCount(newTokenRel);
        return newTokenRel;
    }

    protected void adjustBalance(@NonNull TokenRelation tokenRel, @NonNull Account account, long adjustment, @NonNull WritableTokenRelationStore tokenRelStore, @NonNull WritableAccountStore accountStore) {
        Objects.requireNonNull(tokenRel);
        Objects.requireNonNull(account);
        Objects.requireNonNull(tokenRelStore);
        Objects.requireNonNull(accountStore);
        long originalBalance = tokenRel.balance();
        long newBalance = originalBalance + adjustment;
        HandleException.validateTrue((newBalance >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_TOKEN_BALANCE);
        TokenRelation.Builder copyRel = tokenRel.copyBuilder();
        tokenRelStore.put(copyRel.balance(newBalance).build());
        int numPositiveBalances = account.numberPositiveBalances();
        if (newBalance == 0L && adjustment < 0L) {
            --numPositiveBalances;
        } else if (originalBalance == 0L && adjustment > 0L) {
            ++numPositiveBalances;
        }
        Account.Builder copyAccount = account.copyBuilder();
        accountStore.put(copyAccount.numberPositiveBalances(numPositiveBalances).build());
    }

    protected void validateNotFrozenAndKycOnRelation(@NonNull TokenRelation rel) {
        HandleException.validateTrue((!rel.frozen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN);
        HandleException.validateTrue((boolean)rel.kycGranted(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN);
    }

    protected static boolean updatesAdminOnlyNonKeyTokenProperty(@NonNull TokenUpdateTransactionBody op) {
        return !op.symbol().isEmpty() || !op.name().isEmpty() || op.hasAutoRenewPeriod() || op.hasMemo();
    }

    @NonNull
    public static TokenID asToken(long num) {
        return TokenID.newBuilder().tokenNum(num).build();
    }

    public static boolean isValidTokenId(TokenID tokenId) {
        if (tokenId == null) {
            return false;
        }
        return tokenId.tokenNum() > 0L;
    }

    public static TokenAssociation asTokenAssociation(TokenID tokenId, AccountID accountId) {
        return TokenAssociation.newBuilder().tokenId(tokenId).accountId(accountId).build();
    }

    public static boolean hasUnlimitedAutoAssociations(@NonNull Account account, @NonNull EntitiesConfig entitiesConfig) {
        return entitiesConfig.unlimitedAutoAssociationsEnabled() && account.maxAutoAssociations() == -1;
    }
}

