/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.util;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.PendingAirdropValue;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountPendingAirdrop;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.transaction.PendingAirdropRecord;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableAirdropStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AirdropHandlerHelper {
    private static final Long LAST_RESERVED_SYSTEM_ACCOUNT = 1000L;

    public static Set<PendingAirdropId> standardizeAirdropIds(@NonNull ReadableAccountStore accountStore, @NonNull ReadableAirdropStore airdropStore, @NonNull List<PendingAirdropId> airdropIds, @NonNull Set<IdType> knownExtantIdTypes) {
        LinkedHashSet<PendingAirdropId> standardAirdropIds = new LinkedHashSet<PendingAirdropId>();
        for (PendingAirdropId airdropId : airdropIds) {
            Account sender = knownExtantIdTypes.contains((Object)IdType.SENDER) ? Objects.requireNonNull(accountStore.getAliasedAccountById(airdropId.senderIdOrThrow())) : accountStore.getAliasedAccountById(airdropId.senderIdOrElse(AccountID.DEFAULT));
            HandleException.validateTrue((sender != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_PENDING_AIRDROP_ID);
            Account receiver = knownExtantIdTypes.contains((Object)IdType.RECEIVER) ? Objects.requireNonNull(accountStore.getAliasedAccountById(airdropId.receiverIdOrThrow())) : accountStore.getAliasedAccountById(airdropId.receiverIdOrElse(AccountID.DEFAULT));
            HandleException.validateTrue((receiver != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_PENDING_AIRDROP_ID);
            PendingAirdropId validatedId = airdropId.copyBuilder().senderId(sender.accountIdOrThrow()).receiverId(receiver.accountIdOrThrow()).build();
            HandleException.validateTrue((boolean)airdropStore.exists(validatedId), (ResponseCodeEnum)ResponseCodeEnum.INVALID_PENDING_AIRDROP_ID);
            HandleException.validateFalse((boolean)standardAirdropIds.contains(validatedId), (ResponseCodeEnum)ResponseCodeEnum.PENDING_AIRDROP_ID_REPEATED);
            standardAirdropIds.add(validatedId);
        }
        Set uniqueAirdropIds = Set.copyOf(standardAirdropIds);
        HandleException.validateTrue((standardAirdropIds.size() == uniqueAirdropIds.size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.PENDING_AIRDROP_ID_REPEATED);
        return standardAirdropIds;
    }

    private AirdropHandlerHelper() {
        throw new UnsupportedOperationException("Utility class only");
    }

    public static FungibleAirdropLists separateFungibleTransfers(@NonNull HandleContext context, @NonNull TokenID tokenId, @NonNull List<AccountAmount> transfers) {
        ArrayList<AccountAmount> transferFungibleAmounts = new ArrayList<AccountAmount>();
        ArrayList<AccountAmount> pendingFungibleAmounts = new ArrayList<AccountAmount>();
        LinkedHashSet<AccountID> transfersNeedingAutoAssociation = new LinkedHashSet<AccountID>();
        ReadableTokenRelationStore tokenRelStore = (ReadableTokenRelationStore)context.storeFactory().readableStore(ReadableTokenRelationStore.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)context.storeFactory().readableStore(ReadableAccountStore.class);
        for (AccountAmount aa : transfers) {
            AccountID accountId = aa.accountIDOrElse(AccountID.DEFAULT);
            if (accountStore.isMissing(accountId)) {
                transferFungibleAmounts.add(aa);
                transfersNeedingAutoAssociation.add(accountId);
                continue;
            }
            Account account = TokenHandlerHelper.getIfUsableForAliasedId(accountId, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
            TokenRelation tokenRel = tokenRelStore.get(accountId, tokenId);
            boolean isPendingAirdrop = false;
            if (aa.amount() > 0L) {
                HandleException.validateFalse((boolean)AirdropHandlerHelper.isSystemAccount(account), (ResponseCodeEnum)ResponseCodeEnum.INVALID_RECEIVING_NODE_ACCOUNT);
                isPendingAirdrop = AirdropHandlerHelper.isPendingAirdrop(context, account, tokenRel);
            }
            if (isPendingAirdrop) {
                pendingFungibleAmounts.add(aa);
                continue;
            }
            transferFungibleAmounts.add(aa);
            if (tokenRel != null) continue;
            transfersNeedingAutoAssociation.add(accountId);
        }
        return new FungibleAirdropLists(transferFungibleAmounts, pendingFungibleAmounts, transfersNeedingAutoAssociation.size());
    }

    public static NftAirdropLists separateNftTransfers(HandleContext context, TokenID tokenId, List<NftTransfer> transfers) {
        ArrayList<NftTransfer> transferNftList = new ArrayList<NftTransfer>();
        ArrayList<NftTransfer> pendingNftList = new ArrayList<NftTransfer>();
        HashSet<AccountID> transfersNeedingAutoAssociation = new HashSet<AccountID>();
        for (NftTransfer nftTransfer : transfers) {
            AccountID receiverId;
            ReadableTokenRelationStore tokenRelStore = (ReadableTokenRelationStore)context.storeFactory().readableStore(ReadableTokenRelationStore.class);
            ReadableAccountStore accountStore = (ReadableAccountStore)context.storeFactory().readableStore(ReadableAccountStore.class);
            if (accountStore.isMissing(receiverId = nftTransfer.receiverAccountIDOrElse(AccountID.DEFAULT))) {
                transferNftList.add(nftTransfer);
                transfersNeedingAutoAssociation.add(receiverId);
                continue;
            }
            Account account = TokenHandlerHelper.getIfUsableForAliasedId(receiverId, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
            HandleException.validateFalse((boolean)AirdropHandlerHelper.isSystemAccount(account), (ResponseCodeEnum)ResponseCodeEnum.INVALID_RECEIVING_NODE_ACCOUNT);
            TokenRelation tokenRel = tokenRelStore.get(receiverId, tokenId);
            if (AirdropHandlerHelper.isPendingAirdrop(context, account, tokenRel)) {
                pendingNftList.add(nftTransfer);
                continue;
            }
            transferNftList.add(nftTransfer);
            if (tokenRel != null) continue;
            transfersNeedingAutoAssociation.add(receiverId);
        }
        return new NftAirdropLists(transferNftList, pendingNftList, transfersNeedingAutoAssociation.size());
    }

    private static boolean isPendingAirdrop(@NonNull HandleContext context, @NonNull Account receiver, @Nullable TokenRelation tokenRelation) {
        SignatureVerification sigVerification;
        if (receiver.receiverSigRequired() && (sigVerification = context.keyVerifier().verificationFor(Objects.requireNonNull(receiver.key()))).failed()) {
            return true;
        }
        return tokenRelation == null && AirdropHandlerHelper.isAutoAssociationLimitReached(receiver);
    }

    public static PendingAirdropId createFungibleTokenPendingAirdropId(TokenID tokenId, Account sender, Account receiver) {
        return PendingAirdropId.newBuilder().receiverId(receiver.accountIdOrThrow()).senderId(sender.accountIdOrThrow()).fungibleTokenType(tokenId).build();
    }

    public static PendingAirdropId createFungibleTokenPendingAirdropId(TokenID tokenId, AccountID senderId, AccountID receiverId) {
        return PendingAirdropId.newBuilder().receiverId(receiverId).senderId(senderId).fungibleTokenType(tokenId).build();
    }

    public static PendingAirdropId createNftPendingAirdropId(TokenID tokenId, long serialNumber, Account sender, Account receiver) {
        NftID nftId = NftID.newBuilder().tokenId(tokenId).serialNumber(serialNumber).build();
        return PendingAirdropId.newBuilder().receiverId(receiver.accountIdOrThrow()).senderId(sender.accountIdOrThrow()).nonFungibleToken(nftId).build();
    }

    public static AccountPendingAirdrop createFirstAccountPendingAirdrop(PendingAirdropValue pendingAirdropValue) {
        return AirdropHandlerHelper.createAccountPendingAirdrop(pendingAirdropValue, null);
    }

    public static AccountPendingAirdrop createAccountPendingAirdrop(@Nullable PendingAirdropValue pendingAirdropValue, @Nullable PendingAirdropId next) {
        return AccountPendingAirdrop.newBuilder().pendingAirdropValue(pendingAirdropValue).nextAirdrop(next).build();
    }

    public static PendingAirdropRecord createPendingAirdropRecord(@NonNull PendingAirdropId pendingAirdropId, @Nullable PendingAirdropValue pendingAirdropValue) {
        return PendingAirdropRecord.newBuilder().pendingAirdropId(pendingAirdropId).pendingAirdropValue(pendingAirdropValue).build();
    }

    public static boolean isSystemAccount(@NonNull Account account) {
        Objects.requireNonNull(account);
        return account.accountIdOrThrow().accountNumOrThrow() <= LAST_RESERVED_SYSTEM_ACCOUNT;
    }

    private static boolean isAutoAssociationLimitReached(@NonNull Account receiver) {
        return receiver.maxAutoAssociations() <= receiver.usedAutoAssociations() && receiver.maxAutoAssociations() != -1;
    }

    public static enum IdType {
        SENDER,
        RECEIVER;

    }

    public record FungibleAirdropLists(@NonNull List<AccountAmount> transferFungibleAmounts, @NonNull List<AccountAmount> pendingFungibleAmounts, int transfersNeedingAutoAssociation) {
    }

    public record NftAirdropLists(@NonNull List<NftTransfer> transferNftList, @NonNull List<NftTransfer> pendingNftList, int transfersNeedingAutoAssociation) {
    }
}

