/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoCreateValidator {
    @Inject
    public CryptoCreateValidator() {
    }

    public void validateKey(@NonNull Key key, @NonNull AttributeValidator attributeValidator, boolean isInternalDispatch) {
        boolean isSentinel = KeyUtils.IMMUTABILITY_SENTINEL_KEY.equals((Object)key);
        if (isSentinel && !isInternalDispatch) {
            throw new HandleException(ResponseCodeEnum.KEY_REQUIRED);
        }
        if (!isSentinel) {
            if (!KeyUtils.isValid((Key)key)) {
                throw new HandleException(ResponseCodeEnum.INVALID_ADMIN_KEY);
            }
            attributeValidator.validateKey(key);
        }
    }

    public boolean tooManyAutoAssociations(int numAssociations, @NonNull LedgerConfig ledgerConfig, @NonNull EntitiesConfig entitiesConfig, @NonNull TokensConfig tokensConfig) {
        return entitiesConfig.limitTokenAssociations() && numAssociations > tokensConfig.maxPerAccount() || numAssociations > ledgerConfig.maxAutoAssociations() || numAssociations < -1 && entitiesConfig.unlimitedAutoAssociationsEnabled() || numAssociations < 0 && !entitiesConfig.unlimitedAutoAssociationsEnabled();
    }
}

