/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.log;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.DelegatingBytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.ethereum.rlp.RLPException;
import org.hyperledger.besu.ethereum.rlp.RLPInput;
import org.hyperledger.besu.evm.log.Log;
import org.hyperledger.besu.evm.log.LogTopic;

public class LogsBloomFilter
extends DelegatingBytes {
    public static final int BYTE_SIZE = 256;
    private static final int LEAST_SIGNIFICANT_BYTE = 255;
    private static final int LEAST_SIGNIFICANT_THREE_BITS = 7;
    private static final int BITS_IN_BYTE = 8;

    public LogsBloomFilter() {
        super(Bytes.wrap((byte[])new byte[256]));
    }

    public LogsBloomFilter(MutableBytes data) {
        this(data.copy());
    }

    public LogsBloomFilter(Bytes data) {
        super(data);
        Preconditions.checkArgument((data.size() == 256 ? 1 : 0) != 0, (String)"Invalid size for bloom filter backing array: expected %s but got %s", (int)256, (int)data.size());
    }

    public LogsBloomFilter(String logsBloomHexString) {
        this(Bytes.fromHexString((CharSequence)logsBloomHexString));
    }

    public static LogsBloomFilter fromHexString(String hexString) {
        return new LogsBloomFilter(Bytes.fromHexString((CharSequence)hexString));
    }

    public static LogsBloomFilter empty() {
        return new LogsBloomFilter(Bytes.wrap((byte[])new byte[256]));
    }

    public static LogsBloomFilter readFrom(RLPInput input) {
        Bytes bytes = input.readBytes();
        if (bytes.size() != 256) {
            throw new RLPException(String.format("LogsBloomFilter unexpected size of %s (needs %s)", bytes.size(), 256));
        }
        return new LogsBloomFilter(bytes);
    }

    public boolean couldContain(LogsBloomFilter subset) {
        if (subset == null) {
            return true;
        }
        if (subset.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            byte subsetValue = subset.get(i);
            if ((this.get(i) & subsetValue) == subsetValue) continue;
            return false;
        }
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        final MutableBytes data = MutableBytes.create((int)256);

        private Builder() {
        }

        public Builder insertFilter(LogsBloomFilter other) {
            for (int i = 0; i < this.data.size(); ++i) {
                this.data.set(i, (byte)((this.data.get(i) | other.get(i)) & 0xFF));
            }
            return this;
        }

        public Builder insertLog(Log log) {
            this.insertBytes((Bytes)log.getLogger());
            for (LogTopic topic : log.getTopics()) {
                this.insertBytes((Bytes)topic);
            }
            return this;
        }

        public Builder insertLogs(Collection<Log> logs) {
            logs.forEach(this::insertLog);
            return this;
        }

        public Builder insertBytes(Bytes value) {
            this.setBits((Bytes)Hash.keccak256((Bytes)value));
            return this;
        }

        public LogsBloomFilter build() {
            return new LogsBloomFilter(this.data);
        }

        private void setBits(Bytes hashValue) {
            for (int counter = 0; counter < 6; counter += 2) {
                int setBloomBit = ((hashValue.get(counter) & 7) << 8) + (hashValue.get(counter + 1) & 0xFF);
                this.setBit(setBloomBit);
            }
        }

        private void setBit(int index) {
            int byteIndex = 255 - index / 8;
            int bitIndex = index % 8;
            this.data.set(byteIndex, (byte)(this.data.get(byteIndex) | 1 << bitIndex));
        }
    }
}

