/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.config.impl.internal.ConfigLifecycle;
import com.swirlds.config.impl.internal.ConfigSourceService;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

class ConfigPropertiesService
implements ConfigLifecycle {
    private final Map<String, String> internalProperties;
    private final Map<String, List<String>> internalListProperties;
    private final ConfigSourceService configSourceService;
    private boolean initialized = false;

    ConfigPropertiesService(@NonNull ConfigSourceService configSourceService) {
        this.configSourceService = Objects.requireNonNull(configSourceService, "configSourceService must not be null");
        this.internalProperties = new HashMap<String, String>();
        this.internalListProperties = new HashMap<String, List<String>>();
    }

    @Override
    public void init() {
        this.throwIfInitialized();
        this.configSourceService.getSources().forEach(configSource -> {
            Set propertyNames = configSource.getPropertyNames();
            propertyNames.forEach(propertyName -> {
                ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
                if (configSource.isListProperty(propertyName)) {
                    this.internalListProperties.put((String)propertyName, configSource.getListValue(propertyName));
                } else {
                    this.internalProperties.put((String)propertyName, configSource.getValue(propertyName));
                }
            });
        });
        this.initialized = true;
    }

    @Override
    public void dispose() {
        this.internalProperties.clear();
        this.internalListProperties.clear();
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @NonNull
    Stream<String> getPropertyNames() {
        this.throwIfNotInitialized();
        return Stream.concat(this.internalProperties.keySet().stream(), this.internalListProperties.keySet().stream());
    }

    boolean containsKey(@NonNull String propertyName) {
        this.throwIfNotInitialized();
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        return this.internalProperties.containsKey(propertyName) || this.internalListProperties.containsKey(propertyName);
    }

    @Nullable
    String getProperty(@NonNull String propertyName) {
        this.throwIfNotInitialized();
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        return this.internalProperties.get(propertyName);
    }

    boolean isListProperty(@NonNull String propertyName) {
        this.throwIfNotInitialized();
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        return this.internalListProperties.containsKey(propertyName);
    }

    @NonNull
    List<String> getListProperty(@NonNull String propertyName) {
        this.throwIfNotInitialized();
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        return this.internalListProperties.get(propertyName);
    }
}

