/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.hapi.node.base.codec.AccountAmountJsonCodec;
import com.hedera.hapi.node.base.codec.AccountAmountProtoCodec;
import com.hedera.hapi.node.base.schema.AccountAmountSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class AccountAmount {
    public static final Codec<AccountAmount> PROTOBUF = new AccountAmountProtoCodec();
    public static final JsonCodec<AccountAmount> JSON = new AccountAmountJsonCodec();
    public static final AccountAmount DEFAULT = AccountAmount.newBuilder().build();
    @Nullable
    private final AccountID accountID;
    private final long amount;
    private final boolean isApproval;
    private final OneOf<HookCallOneOfType> hookCall;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public AccountAmount(AccountID accountID, long amount, boolean isApproval, OneOf<HookCallOneOfType> hookCall) {
        this.$unknownFields = null;
        this.accountID = accountID;
        this.amount = amount;
        this.isApproval = isApproval;
        if (hookCall == null) {
            throw new NullPointerException("Parameter 'hookCall' must be supplied and can not be null");
        }
        this.hookCall = hookCall;
    }

    public AccountAmount(AccountID accountID, long amount, boolean isApproval, OneOf<HookCallOneOfType> hookCall, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.accountID = accountID;
        this.amount = amount;
        this.isApproval = isApproval;
        if (hookCall == null) {
            throw new NullPointerException("Parameter 'hookCall' must be supplied and can not be null");
        }
        this.hookCall = hookCall;
    }

    public AccountID accountID() {
        return this.accountID;
    }

    public long amount() {
        return this.amount;
    }

    public boolean isApproval() {
        return this.isApproval;
    }

    public OneOf<HookCallOneOfType> hookCall() {
        return this.hookCall;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountAmountSchema.ACCOUNT_ID, (Object)this.accountID, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountAmountSchema.AMOUNT, (long)this.amount, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountAmountSchema.IS_APPROVAL, (boolean)this.isApproval, (boolean)true);
            if (this.hookCall.kind() == HookCallOneOfType.PRE_TX_ALLOWANCE_HOOK) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountAmountSchema.PRE_TX_ALLOWANCE_HOOK, (Object)((HookCall)this.hookCall.as()), HookCall.PROTOBUF);
            }
            if (this.hookCall.kind() == HookCallOneOfType.PRE_POST_TX_ALLOWANCE_HOOK) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountAmountSchema.PRE_POST_TX_ALLOWANCE_HOOK, (Object)((HookCall)this.hookCall.as()), HookCall.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.accountID != null && !this.accountID.equals(AccountAmount.DEFAULT.accountID)) {
                result = 31 * result + this.accountID.hashCode();
            }
            if (this.amount != AccountAmount.DEFAULT.amount) {
                result = 31 * result + Long.hashCode(this.amount);
            }
            if (this.isApproval != AccountAmount.DEFAULT.isApproval) {
                result = 31 * result + Boolean.hashCode(this.isApproval);
            }
            if (this.hookCall != null && !this.hookCall.equals(AccountAmount.DEFAULT.hookCall)) {
                result = 31 * result + this.hookCall.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AccountAmount thatObj = (AccountAmount)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.accountID == null && thatObj.accountID != null) {
            return false;
        }
        if (this.accountID != null && !this.accountID.equals(thatObj.accountID)) {
            return false;
        }
        if (this.amount != thatObj.amount) {
            return false;
        }
        if (this.isApproval != thatObj.isApproval) {
            return false;
        }
        if (this.hookCall == null && thatObj.hookCall != null) {
            return false;
        }
        if (this.hookCall != null && !this.hookCall.equals(thatObj.hookCall)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "AccountAmount[accountID=" + String.valueOf(this.accountID) + ", amount=" + this.amount + ", isApproval=" + this.isApproval + ", hookCall=" + String.valueOf(this.hookCall) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    @Nullable
    public HookCall preTxAllowanceHook() {
        return this.hookCall.kind() == HookCallOneOfType.PRE_TX_ALLOWANCE_HOOK ? (HookCall)this.hookCall.value() : null;
    }

    public boolean hasPreTxAllowanceHook() {
        return this.hookCall.kind() == HookCallOneOfType.PRE_TX_ALLOWANCE_HOOK;
    }

    public HookCall preTxAllowanceHookOrElse(@NonNull HookCall defaultValue) {
        return this.hasPreTxAllowanceHook() ? this.preTxAllowanceHook() : defaultValue;
    }

    @NonNull
    public HookCall preTxAllowanceHookOrThrow() {
        return Objects.requireNonNull(this.preTxAllowanceHook(), "Field preTxAllowanceHook is null");
    }

    @Nullable
    public HookCall prePostTxAllowanceHook() {
        return this.hookCall.kind() == HookCallOneOfType.PRE_POST_TX_ALLOWANCE_HOOK ? (HookCall)this.hookCall.value() : null;
    }

    public boolean hasPrePostTxAllowanceHook() {
        return this.hookCall.kind() == HookCallOneOfType.PRE_POST_TX_ALLOWANCE_HOOK;
    }

    public HookCall prePostTxAllowanceHookOrElse(@NonNull HookCall defaultValue) {
        return this.hasPrePostTxAllowanceHook() ? this.prePostTxAllowanceHook() : defaultValue;
    }

    @NonNull
    public HookCall prePostTxAllowanceHookOrThrow() {
        return Objects.requireNonNull(this.prePostTxAllowanceHook(), "Field prePostTxAllowanceHook is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.accountID, this.amount, this.isApproval, this.hookCall, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum HookCallOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        PRE_TX_ALLOWANCE_HOOK(4, "pre_tx_allowance_hook"),
        PRE_POST_TX_ALLOWANCE_HOOK(5, "pre_post_tx_allowance_hook");

        private final int protoOrdinal;
        private final String protoName;

        private HookCallOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static HookCallOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 4 -> PRE_TX_ALLOWANCE_HOOK;
                case 5 -> PRE_POST_TX_ALLOWANCE_HOOK;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static HookCallOneOfType fromString(String name) {
            return switch (name) {
                case "pre_tx_allowance_hook", "PRE_TX_ALLOWANCE_HOOK" -> PRE_TX_ALLOWANCE_HOOK;
                case "pre_post_tx_allowance_hook", "PRE_POST_TX_ALLOWANCE_HOOK" -> PRE_POST_TX_ALLOWANCE_HOOK;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        @Nullable
        private AccountID accountID = null;
        private long amount = 0L;
        private boolean isApproval = false;
        private OneOf<HookCallOneOfType> hookCall = AccountAmountProtoCodec.HOOK_CALL_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(AccountID accountID, long amount, boolean isApproval, OneOf<HookCallOneOfType> hookCall) {
            this.$unknownFields = null;
            this.accountID = accountID;
            this.amount = amount;
            this.isApproval = isApproval;
            this.hookCall = hookCall;
        }

        public Builder(AccountID accountID, long amount, boolean isApproval, OneOf<HookCallOneOfType> hookCall, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.accountID = accountID;
            this.amount = amount;
            this.isApproval = isApproval;
            this.hookCall = hookCall;
        }

        public AccountAmount build() {
            return new AccountAmount(this.accountID, this.amount, this.isApproval, this.hookCall);
        }

        public Builder accountID(@Nullable AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder isApproval(boolean isApproval) {
            this.isApproval = isApproval;
            return this;
        }

        public Builder preTxAllowanceHook(@Nullable HookCall preTxAllowanceHook) {
            this.hookCall = new OneOf((Enum)HookCallOneOfType.PRE_TX_ALLOWANCE_HOOK, (Object)preTxAllowanceHook);
            return this;
        }

        public Builder preTxAllowanceHook(HookCall.Builder builder) {
            this.hookCall = new OneOf((Enum)HookCallOneOfType.PRE_TX_ALLOWANCE_HOOK, (Object)builder.build());
            return this;
        }

        public Builder prePostTxAllowanceHook(@Nullable HookCall prePostTxAllowanceHook) {
            this.hookCall = new OneOf((Enum)HookCallOneOfType.PRE_POST_TX_ALLOWANCE_HOOK, (Object)prePostTxAllowanceHook);
            return this;
        }

        public Builder prePostTxAllowanceHook(HookCall.Builder builder) {
            this.hookCall = new OneOf((Enum)HookCallOneOfType.PRE_POST_TX_ALLOWANCE_HOOK, (Object)builder.build());
            return this;
        }
    }
}

