/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.consensus;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.codec.TopicJsonCodec;
import com.hedera.hapi.node.state.consensus.codec.TopicProtoCodec;
import com.hedera.hapi.node.state.consensus.schema.TopicSchema;
import com.hedera.hapi.node.transaction.FixedCustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class Topic {
    public static final Codec<Topic> PROTOBUF = new TopicProtoCodec();
    public static final JsonCodec<Topic> JSON = new TopicJsonCodec();
    public static final Topic DEFAULT = Topic.newBuilder().build();
    @Nullable
    private final TopicID topicId;
    private final long sequenceNumber;
    private final long expirationSecond;
    private final long autoRenewPeriod;
    @Nullable
    private final AccountID autoRenewAccountId;
    private final boolean deleted;
    @NonNull
    private final Bytes runningHash;
    @NonNull
    private final String memo;
    @Nullable
    private final Key adminKey;
    @Nullable
    private final Key submitKey;
    @Nullable
    private final Key feeScheduleKey;
    @NonNull
    private final List<Key> feeExemptKeyList;
    @NonNull
    private final List<FixedCustomFee> customFees;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public Topic(TopicID topicId, long sequenceNumber, long expirationSecond, long autoRenewPeriod, AccountID autoRenewAccountId, boolean deleted, Bytes runningHash, String memo, Key adminKey, Key submitKey, Key feeScheduleKey, List<Key> feeExemptKeyList, List<FixedCustomFee> customFees) {
        this.$unknownFields = null;
        this.topicId = topicId;
        this.sequenceNumber = sequenceNumber;
        this.expirationSecond = expirationSecond;
        this.autoRenewPeriod = autoRenewPeriod;
        this.autoRenewAccountId = autoRenewAccountId;
        this.deleted = deleted;
        this.runningHash = runningHash != null ? runningHash : Bytes.EMPTY;
        this.memo = memo != null ? memo : "";
        this.adminKey = adminKey;
        this.submitKey = submitKey;
        this.feeScheduleKey = feeScheduleKey;
        this.feeExemptKeyList = feeExemptKeyList == null ? Collections.emptyList() : feeExemptKeyList;
        this.customFees = customFees == null ? Collections.emptyList() : customFees;
    }

    public Topic(TopicID topicId, long sequenceNumber, long expirationSecond, long autoRenewPeriod, AccountID autoRenewAccountId, boolean deleted, Bytes runningHash, String memo, Key adminKey, Key submitKey, Key feeScheduleKey, List<Key> feeExemptKeyList, List<FixedCustomFee> customFees, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.topicId = topicId;
        this.sequenceNumber = sequenceNumber;
        this.expirationSecond = expirationSecond;
        this.autoRenewPeriod = autoRenewPeriod;
        this.autoRenewAccountId = autoRenewAccountId;
        this.deleted = deleted;
        this.runningHash = runningHash != null ? runningHash : Bytes.EMPTY;
        this.memo = memo != null ? memo : "";
        this.adminKey = adminKey;
        this.submitKey = submitKey;
        this.feeScheduleKey = feeScheduleKey;
        this.feeExemptKeyList = feeExemptKeyList == null ? Collections.emptyList() : feeExemptKeyList;
        this.customFees = customFees == null ? Collections.emptyList() : customFees;
    }

    public TopicID topicId() {
        return this.topicId;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public long expirationSecond() {
        return this.expirationSecond;
    }

    public long autoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    public AccountID autoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public Bytes runningHash() {
        return this.runningHash;
    }

    public String memo() {
        return this.memo;
    }

    public Key adminKey() {
        return this.adminKey;
    }

    public Key submitKey() {
        return this.submitKey;
    }

    public Key feeScheduleKey() {
        return this.feeScheduleKey;
    }

    public List<Key> feeExemptKeyList() {
        return this.feeExemptKeyList;
    }

    public List<FixedCustomFee> customFees() {
        return this.customFees;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.TOPIC_ID, (Object)this.topicId, TopicID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TopicSchema.SEQUENCE_NUMBER, (long)this.sequenceNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TopicSchema.EXPIRATION_SECOND, (long)this.expirationSecond, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TopicSchema.AUTO_RENEW_PERIOD, (long)this.autoRenewPeriod, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.AUTO_RENEW_ACCOUNT_ID, (Object)this.autoRenewAccountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TopicSchema.DELETED, (boolean)this.deleted, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TopicSchema.RUNNING_HASH, (RandomAccessData)this.runningHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)TopicSchema.MEMO, (String)this.memo, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.ADMIN_KEY, (Object)this.adminKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.SUBMIT_KEY, (Object)this.submitKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.FEE_SCHEDULE_KEY, (Object)this.feeScheduleKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TopicSchema.FEE_EXEMPT_KEY_LIST, this.feeExemptKeyList, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TopicSchema.CUSTOM_FEES, this.customFees, FixedCustomFee.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.$hashCode == -1) {
            List<FixedCustomFee> list$customFees;
            List<Key> list$feeExemptKeyList;
            int result = 1;
            if (this.topicId != null && !this.topicId.equals(Topic.DEFAULT.topicId)) {
                result = 31 * result + this.topicId.hashCode();
            }
            if (this.sequenceNumber != Topic.DEFAULT.sequenceNumber) {
                result = 31 * result + Long.hashCode(this.sequenceNumber);
            }
            if (this.expirationSecond != Topic.DEFAULT.expirationSecond) {
                result = 31 * result + Long.hashCode(this.expirationSecond);
            }
            if (this.autoRenewPeriod != Topic.DEFAULT.autoRenewPeriod) {
                result = 31 * result + Long.hashCode(this.autoRenewPeriod);
            }
            if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(Topic.DEFAULT.autoRenewAccountId)) {
                result = 31 * result + this.autoRenewAccountId.hashCode();
            }
            if (this.deleted != Topic.DEFAULT.deleted) {
                result = 31 * result + Boolean.hashCode(this.deleted);
            }
            if (this.runningHash != null && !this.runningHash.equals((Object)Topic.DEFAULT.runningHash)) {
                result = 31 * result + this.runningHash.hashCode();
            }
            if (this.memo != null && !this.memo.equals(Topic.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.adminKey != null && !this.adminKey.equals(Topic.DEFAULT.adminKey)) {
                result = 31 * result + this.adminKey.hashCode();
            }
            if (this.submitKey != null && !this.submitKey.equals(Topic.DEFAULT.submitKey)) {
                result = 31 * result + this.submitKey.hashCode();
            }
            if (this.feeScheduleKey != null && !this.feeScheduleKey.equals(Topic.DEFAULT.feeScheduleKey)) {
                result = 31 * result + this.feeScheduleKey.hashCode();
            }
            if ((list$feeExemptKeyList = this.feeExemptKeyList) != null) {
                for (Key key : list$feeExemptKeyList) {
                    if (key != null) {
                        result = 31 * result + ((Object)key).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if ((list$customFees = this.customFees) != null) {
                for (FixedCustomFee fixedCustomFee : list$customFees) {
                    if (fixedCustomFee != null) {
                        result = 31 * result + ((Object)fixedCustomFee).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.$unknownFields != null) {
                void var4_8;
                boolean bl = false;
                while (var4_8 < this.$unknownFields.size()) {
                    result = 31 * result + this.$unknownFields.get((int)var4_8).hashCode();
                    ++var4_8;
                }
            }
            long l = result;
            l += l << 30;
            l ^= l >>> 27;
            l += l << 16;
            l ^= l >>> 20;
            l += l << 5;
            l ^= l >>> 18;
            l += l << 10;
            l ^= l >>> 24;
            l += l << 30;
            this.$hashCode = (int)l;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Topic thatObj = (Topic)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.topicId == null && thatObj.topicId != null) {
            return false;
        }
        if (this.topicId != null && !this.topicId.equals(thatObj.topicId)) {
            return false;
        }
        if (this.sequenceNumber != thatObj.sequenceNumber) {
            return false;
        }
        if (this.expirationSecond != thatObj.expirationSecond) {
            return false;
        }
        if (this.autoRenewPeriod != thatObj.autoRenewPeriod) {
            return false;
        }
        if (this.autoRenewAccountId == null && thatObj.autoRenewAccountId != null) {
            return false;
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(thatObj.autoRenewAccountId)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.runningHash == null && thatObj.runningHash != null) {
            return false;
        }
        if (this.runningHash != null && !this.runningHash.equals((Object)thatObj.runningHash)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.submitKey == null && thatObj.submitKey != null) {
            return false;
        }
        if (this.submitKey != null && !this.submitKey.equals(thatObj.submitKey)) {
            return false;
        }
        if (this.feeScheduleKey == null && thatObj.feeScheduleKey != null) {
            return false;
        }
        if (this.feeScheduleKey != null && !this.feeScheduleKey.equals(thatObj.feeScheduleKey)) {
            return false;
        }
        if (this.feeExemptKeyList == null && thatObj.feeExemptKeyList != null) {
            return false;
        }
        if (this.feeExemptKeyList != null && !this.feeExemptKeyList.equals(thatObj.feeExemptKeyList)) {
            return false;
        }
        if (this.customFees == null && thatObj.customFees != null) {
            return false;
        }
        if (this.customFees != null && !this.customFees.equals(thatObj.customFees)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "Topic[topicId=" + String.valueOf(this.topicId) + ", sequenceNumber=" + this.sequenceNumber + ", expirationSecond=" + this.expirationSecond + ", autoRenewPeriod=" + this.autoRenewPeriod + ", autoRenewAccountId=" + String.valueOf(this.autoRenewAccountId) + ", deleted=" + this.deleted + ", runningHash=" + String.valueOf(this.runningHash) + ", memo=" + this.memo + ", adminKey=" + String.valueOf(this.adminKey) + ", submitKey=" + String.valueOf(this.submitKey) + ", feeScheduleKey=" + String.valueOf(this.feeScheduleKey) + ", feeExemptKeyList=" + String.valueOf(this.feeExemptKeyList) + ", customFees=" + String.valueOf(this.customFees) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasTopicId() {
        return this.topicId != null;
    }

    public TopicID topicIdOrElse(@NonNull TopicID defaultValue) {
        return this.hasTopicId() ? this.topicId : defaultValue;
    }

    @NonNull
    public TopicID topicIdOrThrow() {
        return Objects.requireNonNull(this.topicId, "Field topicId is null");
    }

    public void ifTopicId(@NonNull Consumer<TopicID> ifPresent) {
        if (this.hasTopicId()) {
            ifPresent.accept(this.topicId);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasSubmitKey() {
        return this.submitKey != null;
    }

    public Key submitKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSubmitKey() ? this.submitKey : defaultValue;
    }

    @NonNull
    public Key submitKeyOrThrow() {
        return Objects.requireNonNull(this.submitKey, "Field submitKey is null");
    }

    public void ifSubmitKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSubmitKey()) {
            ifPresent.accept(this.submitKey);
        }
    }

    public boolean hasFeeScheduleKey() {
        return this.feeScheduleKey != null;
    }

    public Key feeScheduleKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFeeScheduleKey() ? this.feeScheduleKey : defaultValue;
    }

    @NonNull
    public Key feeScheduleKeyOrThrow() {
        return Objects.requireNonNull(this.feeScheduleKey, "Field feeScheduleKey is null");
    }

    public void ifFeeScheduleKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFeeScheduleKey()) {
            ifPresent.accept(this.feeScheduleKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.topicId, this.sequenceNumber, this.expirationSecond, this.autoRenewPeriod, this.autoRenewAccountId, this.deleted, this.runningHash, this.memo, this.adminKey, this.submitKey, this.feeScheduleKey, this.feeExemptKeyList, this.customFees, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TopicID topicId = null;
        private long sequenceNumber = 0L;
        private long expirationSecond = 0L;
        private long autoRenewPeriod = 0L;
        @Nullable
        private AccountID autoRenewAccountId = null;
        private boolean deleted = false;
        @NonNull
        private Bytes runningHash = Bytes.EMPTY;
        @NonNull
        private String memo = "";
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Key submitKey = null;
        @Nullable
        private Key feeScheduleKey = null;
        @NonNull
        private List<Key> feeExemptKeyList = Collections.emptyList();
        @NonNull
        private List<FixedCustomFee> customFees = Collections.emptyList();
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(TopicID topicId, long sequenceNumber, long expirationSecond, long autoRenewPeriod, AccountID autoRenewAccountId, boolean deleted, Bytes runningHash, String memo, Key adminKey, Key submitKey, Key feeScheduleKey, List<Key> feeExemptKeyList, List<FixedCustomFee> customFees) {
            this.$unknownFields = null;
            this.topicId = topicId;
            this.sequenceNumber = sequenceNumber;
            this.expirationSecond = expirationSecond;
            this.autoRenewPeriod = autoRenewPeriod;
            this.autoRenewAccountId = autoRenewAccountId;
            this.deleted = deleted;
            this.runningHash = runningHash != null ? runningHash : Bytes.EMPTY;
            this.memo = memo != null ? memo : "";
            this.adminKey = adminKey;
            this.submitKey = submitKey;
            this.feeScheduleKey = feeScheduleKey;
            this.feeExemptKeyList = feeExemptKeyList == null ? Collections.emptyList() : feeExemptKeyList;
            this.customFees = customFees == null ? Collections.emptyList() : customFees;
        }

        public Builder(TopicID topicId, long sequenceNumber, long expirationSecond, long autoRenewPeriod, AccountID autoRenewAccountId, boolean deleted, Bytes runningHash, String memo, Key adminKey, Key submitKey, Key feeScheduleKey, List<Key> feeExemptKeyList, List<FixedCustomFee> customFees, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.topicId = topicId;
            this.sequenceNumber = sequenceNumber;
            this.expirationSecond = expirationSecond;
            this.autoRenewPeriod = autoRenewPeriod;
            this.autoRenewAccountId = autoRenewAccountId;
            this.deleted = deleted;
            this.runningHash = runningHash != null ? runningHash : Bytes.EMPTY;
            this.memo = memo != null ? memo : "";
            this.adminKey = adminKey;
            this.submitKey = submitKey;
            this.feeScheduleKey = feeScheduleKey;
            this.feeExemptKeyList = feeExemptKeyList == null ? Collections.emptyList() : feeExemptKeyList;
            this.customFees = customFees == null ? Collections.emptyList() : customFees;
        }

        public Topic build() {
            return new Topic(this.topicId, this.sequenceNumber, this.expirationSecond, this.autoRenewPeriod, this.autoRenewAccountId, this.deleted, this.runningHash, this.memo, this.adminKey, this.submitKey, this.feeScheduleKey, this.feeExemptKeyList, this.customFees);
        }

        public Builder topicId(@Nullable TopicID topicId) {
            this.topicId = topicId;
            return this;
        }

        public Builder topicId(TopicID.Builder builder) {
            this.topicId = builder.build();
            return this;
        }

        public Builder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder expirationSecond(long expirationSecond) {
            this.expirationSecond = expirationSecond;
            return this;
        }

        public Builder autoRenewPeriod(long autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewAccountId(@Nullable AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder runningHash(@NonNull Bytes runningHash) {
            this.runningHash = runningHash != null ? runningHash : Bytes.EMPTY;
            return this;
        }

        public Builder memo(@NonNull String memo) {
            this.memo = memo != null ? memo : "";
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder submitKey(@Nullable Key submitKey) {
            this.submitKey = submitKey;
            return this;
        }

        public Builder submitKey(Key.Builder builder) {
            this.submitKey = builder.build();
            return this;
        }

        public Builder feeScheduleKey(@Nullable Key feeScheduleKey) {
            this.feeScheduleKey = feeScheduleKey;
            return this;
        }

        public Builder feeScheduleKey(Key.Builder builder) {
            this.feeScheduleKey = builder.build();
            return this;
        }

        public Builder feeExemptKeyList(@NonNull List<Key> feeExemptKeyList) {
            this.feeExemptKeyList = feeExemptKeyList != null ? feeExemptKeyList : Collections.emptyList();
            return this;
        }

        public Builder feeExemptKeyList(Key ... values) {
            this.feeExemptKeyList = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder customFees(@NonNull List<FixedCustomFee> customFees) {
            this.customFees = customFees != null ? customFees : Collections.emptyList();
            return this;
        }

        public Builder customFees(FixedCustomFee ... values) {
            this.customFees = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }
    }
}

