/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.PendingAirdropRecord;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TransactionRecordJsonCodec
implements JsonCodec<TransactionRecord> {
    public static final OneOf<TransactionRecord.BodyOneOfType> BODY_UNSET = new OneOf((Enum)TransactionRecord.BodyOneOfType.UNSET, null);
    public static final OneOf<TransactionRecord.EntropyOneOfType> ENTROPY_UNSET = new OneOf((Enum)TransactionRecord.EntropyOneOfType.UNSET, null);

    @NonNull
    public TransactionRecord parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            TransactionReceipt temp_receipt = null;
            Bytes temp_transactionHash = Bytes.EMPTY;
            Timestamp temp_consensusTimestamp = null;
            TransactionID temp_transactionID = null;
            String temp_memo = "";
            long temp_transactionFee = 0L;
            OneOf temp_body = BODY_UNSET;
            TransferList temp_transferList = null;
            List temp_tokenTransferLists = Collections.emptyList();
            ScheduleID temp_scheduleRef = null;
            List temp_assessed_custom_fees = Collections.emptyList();
            List temp_automatic_token_associations = Collections.emptyList();
            Timestamp temp_parent_consensus_timestamp = null;
            Bytes temp_alias = Bytes.EMPTY;
            Bytes temp_ethereum_hash = Bytes.EMPTY;
            List temp_paid_staking_rewards = Collections.emptyList();
            OneOf temp_entropy = ENTROPY_UNSET;
            Bytes temp_evm_address = Bytes.EMPTY;
            List temp_new_pending_airdrops = Collections.emptyList();
            block48: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "receipt": {
                        temp_receipt = (TransactionReceipt)TransactionReceipt.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block48;
                    }
                    case "transactionHash": {
                        temp_transactionHash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block48;
                    }
                    case "consensusTimestamp": {
                        temp_consensusTimestamp = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block48;
                    }
                    case "transactionID": {
                        temp_transactionID = (TransactionID)TransactionID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block48;
                    }
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block48;
                    }
                    case "transactionFee": {
                        temp_transactionFee = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block48;
                    }
                    case "contractCallResult": {
                        temp_body = new OneOf((Enum)TransactionRecord.BodyOneOfType.CONTRACT_CALL_RESULT, ContractFunctionResult.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block48;
                    }
                    case "contractCreateResult": {
                        temp_body = new OneOf((Enum)TransactionRecord.BodyOneOfType.CONTRACT_CREATE_RESULT, ContractFunctionResult.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block48;
                    }
                    case "transferList": {
                        temp_transferList = (TransferList)TransferList.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block48;
                    }
                    case "tokenTransferLists": {
                        temp_tokenTransferLists = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), TokenTransferList.JSON, (int)(maxDepth - 1));
                        continue block48;
                    }
                    case "scheduleRef": {
                        temp_scheduleRef = (ScheduleID)ScheduleID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block48;
                    }
                    case "assessedCustomFees": {
                        temp_assessed_custom_fees = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), AssessedCustomFee.JSON, (int)(maxDepth - 1));
                        continue block48;
                    }
                    case "automaticTokenAssociations": {
                        temp_automatic_token_associations = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), TokenAssociation.JSON, (int)(maxDepth - 1));
                        continue block48;
                    }
                    case "parentConsensusTimestamp": {
                        temp_parent_consensus_timestamp = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block48;
                    }
                    case "alias": {
                        temp_alias = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block48;
                    }
                    case "ethereumHash": {
                        temp_ethereum_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block48;
                    }
                    case "paidStakingRewards": {
                        temp_paid_staking_rewards = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), AccountAmount.JSON, (int)(maxDepth - 1));
                        continue block48;
                    }
                    case "prngBytes": {
                        temp_entropy = new OneOf((Enum)TransactionRecord.EntropyOneOfType.PRNG_BYTES, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block48;
                    }
                    case "prngNumber": {
                        temp_entropy = new OneOf((Enum)TransactionRecord.EntropyOneOfType.PRNG_NUMBER, (Object)JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value()));
                        continue block48;
                    }
                    case "evmAddress": {
                        temp_evm_address = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block48;
                    }
                    case "newPendingAirdrops": {
                        temp_new_pending_airdrops = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), PendingAirdropRecord.JSON, (int)(maxDepth - 1));
                        continue block48;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new TransactionRecord(temp_receipt, temp_transactionHash, temp_consensusTimestamp, temp_transactionID, temp_memo, temp_transactionFee, temp_body, temp_transferList, temp_tokenTransferLists, temp_scheduleRef, temp_assessed_custom_fees, temp_automatic_token_associations, temp_parent_consensus_timestamp, temp_alias, temp_ethereum_hash, temp_paid_staking_rewards, temp_entropy, temp_evm_address, temp_new_pending_airdrops);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull TransactionRecord data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.receipt() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"receipt", TransactionReceipt.JSON, (Object)data.receipt()));
        }
        if (data.transactionHash() != Bytes.EMPTY && data.transactionHash() != null && data.transactionHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"transactionHash", (Bytes)data.transactionHash()));
        }
        if (data.consensusTimestamp() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"consensusTimestamp", Timestamp.JSON, (Object)data.consensusTimestamp()));
        }
        if (data.transactionID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"transactionID", TransactionID.JSON, (Object)data.transactionID()));
        }
        if (data.memo() != "") {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.transactionFee() != 0L) {
            fieldLines.add(JsonTools.field((String)"transactionFee", (long)data.transactionFee()));
        }
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CALL_RESULT) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractCallResult", ContractFunctionResult.JSON, (Object)data.contractCallResult()));
        }
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CREATE_RESULT) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractCreateResult", ContractFunctionResult.JSON, (Object)data.contractCreateResult()));
        }
        if (data.transferList() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"transferList", TransferList.JSON, (Object)data.transferList()));
        }
        if (!data.tokenTransferLists().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"tokenTransferLists", TokenTransferList.JSON, data.tokenTransferLists()));
        }
        if (data.scheduleRef() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduleRef", ScheduleID.JSON, (Object)data.scheduleRef()));
        }
        if (!data.assessedCustomFees().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"assessedCustomFees", AssessedCustomFee.JSON, data.assessedCustomFees()));
        }
        if (!data.automaticTokenAssociations().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"automaticTokenAssociations", TokenAssociation.JSON, data.automaticTokenAssociations()));
        }
        if (data.parentConsensusTimestamp() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"parentConsensusTimestamp", Timestamp.JSON, (Object)data.parentConsensusTimestamp()));
        }
        if (data.alias() != Bytes.EMPTY && data.alias() != null && data.alias().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"alias", (Bytes)data.alias()));
        }
        if (data.ethereumHash() != Bytes.EMPTY && data.ethereumHash() != null && data.ethereumHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"ethereumHash", (Bytes)data.ethereumHash()));
        }
        if (!data.paidStakingRewards().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"paidStakingRewards", AccountAmount.JSON, data.paidStakingRewards()));
        }
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_BYTES) {
            fieldLines.add(JsonTools.field((String)"prngBytes", (Bytes)data.prngBytes()));
        }
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_NUMBER) {
            fieldLines.add(JsonTools.field((String)"prngNumber", (Integer)data.prngNumber()));
        }
        if (data.evmAddress() != Bytes.EMPTY && data.evmAddress() != null && data.evmAddress().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"evmAddress", (Bytes)data.evmAddress()));
        }
        if (!data.newPendingAirdrops().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"newPendingAirdrops", PendingAirdropRecord.JSON, data.newPendingAirdrops()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

