/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.StateValue;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class OnDiskWritableSingletonState<V>
extends WritableSingletonStateBase<V> {
    @NonNull
    private final VirtualMap virtualMap;
    @NonNull
    private final Codec<StateValue<V>> stateValueCodec;

    public OnDiskWritableSingletonState(int stateId, @NonNull String label, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        super(stateId, Objects.requireNonNull(label));
        this.stateValueCodec = new StateValue.StateValueCodec<V>(stateId, Objects.requireNonNull(valueCodec));
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    protected V readFromDataSource() {
        Bytes stateKey = StateUtils.getStateKeyForSingleton(this.stateId);
        StateValue stateValue = (StateValue)this.virtualMap.get(stateKey, this.stateValueCodec);
        V value = stateValue != null ? (V)stateValue.value() : null;
        StateLogger.logSingletonRead(this.label, value);
        return value;
    }

    protected void putIntoDataSource(@NonNull V value) {
        Bytes stateKey = StateUtils.getStateKeyForSingleton(this.stateId);
        StateValue<V> stateValue = StateUtils.getStateValueForSingleton(this.stateId, value);
        this.virtualMap.put(stateKey, stateValue, this.stateValueCodec);
        StateLogger.logSingletonWrite(this.label, value);
    }

    protected void removeFromDataSource() {
        Bytes stateKey = StateUtils.getStateKeyForSingleton(this.stateId);
        StateValue stateValue = (StateValue)this.virtualMap.remove(stateKey, this.stateValueCodec);
        Object removedValue = stateValue != null ? (Object)stateValue.value() : null;
        StateLogger.logSingletonRemove(this.label, removedValue);
    }
}

