/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import java.math.BigInteger;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.bouncycastle.math.ec.ECPoint;
import org.hyperledger.besu.crypto.KeyPair;
import org.hyperledger.besu.crypto.SECPPrivateKey;
import org.hyperledger.besu.crypto.SECPPublicKey;
import org.hyperledger.besu.crypto.SECPSignature;

public interface SignatureAlgorithm {
    public static final String ALGORITHM = "ECDSA";

    public void disableNative();

    public boolean isNative();

    public SECPSignature sign(Bytes32 var1, KeyPair var2);

    public boolean verify(Bytes var1, SECPSignature var2, SECPPublicKey var3);

    public boolean verify(Bytes var1, SECPSignature var2, SECPPublicKey var3, UnaryOperator<Bytes> var4);

    public SECPSignature normaliseSignature(BigInteger var1, BigInteger var2, SECPPublicKey var3, Bytes32 var4);

    public Bytes32 calculateECDHKeyAgreement(SECPPrivateKey var1, SECPPublicKey var2);

    public BigInteger getHalfCurveOrder();

    public String getProvider();

    public String getCurveName();

    public SECPPrivateKey createPrivateKey(BigInteger var1);

    public SECPPrivateKey createPrivateKey(Bytes32 var1);

    public SECPPublicKey createPublicKey(SECPPrivateKey var1);

    public SECPPublicKey createPublicKey(BigInteger var1);

    public SECPPublicKey createPublicKey(Bytes var1);

    public Optional<SECPPublicKey> recoverPublicKeyFromSignature(Bytes32 var1, SECPSignature var2);

    public ECPoint publicKeyAsEcPoint(SECPPublicKey var1);

    public boolean isValidPublicKey(SECPPublicKey var1);

    public KeyPair createKeyPair(SECPPrivateKey var1);

    public KeyPair generateKeyPair();

    public SECPSignature createSignature(BigInteger var1, BigInteger var2, byte var3);

    public SECPSignature decodeSignature(Bytes var1);

    public Bytes compressPublicKey(SECPPublicKey var1);
}

