/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.extensions;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.common.time.IntegerEpochTime;
import com.swirlds.metrics.api.Metrics;
import java.util.Objects;

public class CountPerSecond {
    private final IntegerEpochTime time;
    private final IntegerPairAccumulator<Double> accumulator;

    public CountPerSecond(Metrics metrics, Config config) {
        this(metrics, config, new IntegerEpochTime(Time.getCurrent()));
    }

    public CountPerSecond(Metrics metrics, Config config, IntegerEpochTime time) {
        this.time = time;
        this.accumulator = (IntegerPairAccumulator)metrics.getOrCreate(new IntegerPairAccumulator.Config<Double>(config.getCategory(), config.getName(), Double.class, this::perSecond).withDescription(config.getDescription()).withUnit(config.getUnit()).withFormat(config.getFormat()).withLeftAccumulator(CountPerSecond::noChangeAccumulator).withRightAccumulator(Integer::sum).withLeftInitializer(this.time::getMilliTime).withRightInitialValue(0));
    }

    public static int noChangeAccumulator(int currentValue, int ignored) {
        return currentValue;
    }

    public void count() {
        this.count(1);
    }

    public void count(int count) {
        this.accumulator.update(0, count);
    }

    private double perSecond(int startTime, int count) {
        int millisElapsed = this.time.millisElapsed(startTime);
        if (millisElapsed == 0) {
            millisElapsed = 1;
        }
        return (double)count / ((double)millisElapsed * 0.001);
    }

    public void reset() {
        this.accumulator.reset();
    }

    public double get() {
        return this.accumulator.get();
    }

    public static final class Config {
        private final String category;
        private final String name;
        private final String description;
        private final String unit;
        private final String format;

        public Config(String category, String name) {
            this(category, name, name, "Hz", "%,10.2f");
        }

        private Config(String category, String name, String description, String unit, String format) {
            this.category = ArgumentUtils.throwArgBlank((String)category, (String)"category");
            this.name = ArgumentUtils.throwArgBlank((String)name, (String)"name");
            this.description = ArgumentUtils.throwArgBlank((String)description, (String)"description");
            this.unit = Objects.requireNonNull(unit, "unit must not be null");
            this.format = ArgumentUtils.throwArgBlank((String)format, (String)"format");
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Config withDescription(String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat());
        }

        public String getUnit() {
            return this.unit;
        }

        public Config withUnit(String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat());
        }

        public String getFormat() {
            return this.format;
        }

        public Config withFormat(String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format);
        }
    }
}

