/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.groups;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.util.Lists;

public final class Tuple {
    private final List<Object> values;

    public Tuple(Object ... values) {
        this.values = Lists.list(values);
    }

    public Object[] toArray() {
        return this.values.toArray();
    }

    public List<Object> toList() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return Arrays.deepEquals(this.values.toArray(), other.values.toArray());
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.values.toArray());
    }

    public String toString() {
        return ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(this);
    }

    public static Tuple tuple(Object ... values) {
        return new Tuple(values);
    }
}

