/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.logging;

import com.swirlds.common.formatting.TextEffect;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;

public class HtmlColors {
    public static final Map<TextEffect, String> ansiToHtmlColors = Map.of(TextEffect.WHITE, "#808181", TextEffect.GRAY, "#595858", TextEffect.BRIGHT_RED, "#f13f4c", TextEffect.BRIGHT_GREEN, "#4db815", TextEffect.BRIGHT_YELLOW, "#e5be01", TextEffect.BRIGHT_BLUE, "#1ea6ee", TextEffect.BRIGHT_PURPLE, "#ed7fec", TextEffect.BRIGHT_CYAN, "#00e5e5", TextEffect.BRIGHT_WHITE, "#fdfcfc");

    private HtmlColors() {
    }

    @NonNull
    public static String getHtmlColor(@NonNull TextEffect ansiColor) {
        Objects.requireNonNull(ansiColor);
        if (!ansiToHtmlColors.containsKey(ansiColor)) {
            throw new IllegalArgumentException("The given ANSI color is not supported: " + String.valueOf(ansiColor));
        }
        return ansiToHtmlColors.get(ansiColor);
    }
}

