/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.gui;

import com.swirlds.platform.test.fixtures.gui.GuiEventProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.model.event.PlatformEvent;

public class ListEventProvider
implements GuiEventProvider {
    private final List<PlatformEvent> events;
    private int index;

    public ListEventProvider(@NonNull List<PlatformEvent> events) {
        Objects.requireNonNull(events);
        this.events = events;
        this.index = 0;
    }

    @Override
    @NonNull
    public List<PlatformEvent> provideEvents(int numberOfEvents) {
        if (this.index >= this.events.size()) {
            return List.of();
        }
        int toIndex = Math.min(this.index + numberOfEvents, this.events.size());
        List<PlatformEvent> list = this.events.subList(this.index, toIndex);
        this.index = toIndex;
        return list;
    }

    @Override
    public void reset() {
        this.index = 0;
    }
}

