/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import com.swirlds.config.api.converter.ConfigConverter;
import com.swirlds.config.impl.converters.BigDecimalConverter;
import com.swirlds.config.impl.converters.BigIntegerConverter;
import com.swirlds.config.impl.converters.BooleanConverter;
import com.swirlds.config.impl.converters.ByteConverter;
import com.swirlds.config.impl.converters.ChronoUnitConverter;
import com.swirlds.config.impl.converters.DoubleConverter;
import com.swirlds.config.impl.converters.DurationConverter;
import com.swirlds.config.impl.converters.EnumConverter;
import com.swirlds.config.impl.converters.FileConverter;
import com.swirlds.config.impl.converters.FloatConverter;
import com.swirlds.config.impl.converters.InetAddressConverter;
import com.swirlds.config.impl.converters.IntegerConverter;
import com.swirlds.config.impl.converters.LongConverter;
import com.swirlds.config.impl.converters.PathConverter;
import com.swirlds.config.impl.converters.ShortConverter;
import com.swirlds.config.impl.converters.StringConverter;
import com.swirlds.config.impl.converters.UriConverter;
import com.swirlds.config.impl.converters.UrlConverter;
import com.swirlds.config.impl.converters.ZonedDateTimeConverter;
import com.swirlds.config.impl.internal.ConfigLifecycle;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

class ConverterService
implements ConfigLifecycle {
    private final Map<Class<?>, ConfigConverter<?>> converters = new ConcurrentHashMap();
    private boolean initialized = false;
    private static final ConfigConverter<String> STRING_CONVERTER = new StringConverter();
    private static final ConfigConverter<Integer> INTEGER_CONVERTER = new IntegerConverter();
    private static final ConfigConverter<Long> LONG_CONVERTER = new LongConverter();
    private static final ConfigConverter<Double> DOUBLE_CONVERTER = new DoubleConverter();
    private static final ConfigConverter<Float> FLOAT_CONVERTER = new FloatConverter();
    private static final ConfigConverter<Short> SHORT_CONVERTER = new ShortConverter();
    private static final ConfigConverter<Byte> BYTE_CONVERTER = new ByteConverter();
    private static final ConfigConverter<Boolean> BOOLEAN_CONVERTER = new BooleanConverter();
    private static final ConfigConverter<BigDecimal> BIG_DECIMAL_CONVERTER = new BigDecimalConverter();
    private static final ConfigConverter<BigInteger> BIG_INTEGER_CONVERTER = new BigIntegerConverter();
    private static final ConfigConverter<URL> URL_CONVERTER = new UrlConverter();
    private static final ConfigConverter<URI> URI_CONVERTER = new UriConverter();
    private static final ConfigConverter<Path> PATH_CONVERTER = new PathConverter();
    private static final ConfigConverter<File> FILE_CONVERTER = new FileConverter();
    private static final ConfigConverter<ZonedDateTime> ZONED_DATE_TIME_CONVERTER = new ZonedDateTimeConverter();
    private static final ConfigConverter<Duration> DURATION_CONVERTER = new DurationConverter();
    private static final ConfigConverter<ChronoUnit> CHRONO_UNIT_CONVERTER = new ChronoUnitConverter();
    private static final ConfigConverter<InetAddress> INET_ADDRESS_CONFIG_CONVERTER = new InetAddressConverter();

    ConverterService() {
    }

    @Nullable
    <T> T convert(@Nullable String value, @NonNull Class<T> targetClass) {
        this.throwIfNotInitialized();
        Objects.requireNonNull(targetClass, "targetClass must not be null");
        if (value == null) {
            return null;
        }
        if (Objects.equals(targetClass, String.class)) {
            return (T)value;
        }
        ConfigConverter<T> converter = this.getOrAdConverter(targetClass);
        if (converter == null) {
            throw new IllegalArgumentException("No converter defined for type '" + String.valueOf(targetClass) + "'");
        }
        try {
            return (T)converter.convert(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can not convert to '" + String.valueOf(targetClass) + "'", ex);
        }
    }

    <T> void addConverter(@NonNull Class<T> converterType, @NonNull ConfigConverter<T> converter) {
        this.throwIfInitialized();
        Objects.requireNonNull(converterType, "converterType must not be null");
        Objects.requireNonNull(converter, "converter must not be null");
        if (this.converters.containsKey(converterType)) {
            if (this.initialized) {
                throw new IllegalStateException("Converter for type '" + String.valueOf(converterType) + "' already registered");
            }
            return;
        }
        this.converters.put(converterType, converter);
    }

    void clear() {
        this.converters.clear();
    }

    @Override
    public void init() {
        this.throwIfInitialized();
        this.addConverter(Integer.TYPE, INTEGER_CONVERTER);
        this.addConverter(Long.TYPE, LONG_CONVERTER);
        this.addConverter(Double.TYPE, DOUBLE_CONVERTER);
        this.addConverter(Float.TYPE, FLOAT_CONVERTER);
        this.addConverter(Short.TYPE, SHORT_CONVERTER);
        this.addConverter(Byte.TYPE, BYTE_CONVERTER);
        this.addConverter(Boolean.TYPE, BOOLEAN_CONVERTER);
        this.addConverter(String.class, STRING_CONVERTER);
        this.addConverter(Integer.class, INTEGER_CONVERTER);
        this.addConverter(Long.class, LONG_CONVERTER);
        this.addConverter(Double.class, DOUBLE_CONVERTER);
        this.addConverter(Float.class, FLOAT_CONVERTER);
        this.addConverter(Short.class, SHORT_CONVERTER);
        this.addConverter(Byte.class, BYTE_CONVERTER);
        this.addConverter(Boolean.class, BOOLEAN_CONVERTER);
        this.addConverter(BigDecimal.class, BIG_DECIMAL_CONVERTER);
        this.addConverter(BigInteger.class, BIG_INTEGER_CONVERTER);
        this.addConverter(URL.class, URL_CONVERTER);
        this.addConverter(URI.class, URI_CONVERTER);
        this.addConverter(Path.class, PATH_CONVERTER);
        this.addConverter(File.class, FILE_CONVERTER);
        this.addConverter(ZonedDateTime.class, ZONED_DATE_TIME_CONVERTER);
        this.addConverter(Duration.class, DURATION_CONVERTER);
        this.addConverter(ChronoUnit.class, CHRONO_UNIT_CONVERTER);
        this.addConverter(InetAddress.class, INET_ADDRESS_CONFIG_CONVERTER);
        this.initialized = true;
    }

    @Override
    public void dispose() {
        this.converters.clear();
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Nullable
    <T> ConfigConverter<T> getConverterForType(@NonNull Class<T> valueType) {
        this.throwIfNotInitialized();
        Objects.requireNonNull(valueType, "valueType must not be null");
        return this.getOrAdConverter(valueType);
    }

    private <T> ConfigConverter<T> getOrAdConverter(@NonNull Class<T> valueType) {
        ConfigConverter<?> converter = this.converters.get(valueType);
        if (converter == null && valueType.isEnum()) {
            return this.converters.computeIfAbsent(valueType, c -> new EnumConverter(c));
        }
        return converter;
    }
}

