/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol;

import com.swirlds.platform.state.signed.ReservedSignedState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.base.concurrent.BlockingResourceProvider;
import org.hiero.base.concurrent.locks.locked.LockedResource;

public class ReservedSignedStateResultPromise {
    private final BlockingResourceProvider<ReservedSignedStateResult> provider = new BlockingResourceProvider();

    public void resolveWithValue(@NonNull ReservedSignedState value) throws InterruptedException {
        this.provider.provide((Object)new ReservedSignedStateResult(value, null));
    }

    public void resolveWithException(@NonNull RuntimeException exception) throws InterruptedException {
        this.provider.provide((Object)new ReservedSignedStateResult(null, exception));
    }

    public boolean acquire() {
        return this.provider.acquireProvidePermit();
    }

    public boolean tryBlock() {
        return this.provider.tryBlockProvidePermit();
    }

    public void release() {
        this.provider.releaseProvidePermit();
    }

    @Nullable
    public LockedResource<ReservedSignedStateResult> awaitResolution() throws InterruptedException {
        return this.provider.waitForResource();
    }

    public record ReservedSignedStateResult(ReservedSignedState reservedSignedState, RuntimeException throwable) implements AutoCloseable
    {
        @Override
        public void close() {
            if (this.reservedSignedState != null) {
                this.reservedSignedState.close();
            }
        }

        public boolean isError() {
            return this.reservedSignedState() == null && this.throwable() != null;
        }
    }
}

