/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.crypto;

import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.crypto.KeyCertPurpose;
import com.swirlds.platform.crypto.KeyLoadingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.stream.Stream;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.consensus.model.node.NodeId;

public record PublicStores(KeyStore sigTrustStore, KeyStore agrTrustStore) {
    public PublicStores() throws KeyStoreException {
        this(CryptoStatic.createEmptyTrustStore(), CryptoStatic.createEmptyTrustStore());
    }

    public static PublicStores fromAllPublic(KeyStore allPublic, Iterable<NodeId> nodeIds) throws KeyStoreException, KeyLoadingException {
        KeyStore sigTrustStore = CryptoStatic.createEmptyTrustStore();
        KeyStore agrTrustStore = CryptoStatic.createEmptyTrustStore();
        for (NodeId nodeId : nodeIds) {
            Certificate sigCert = allPublic.getCertificate(KeyCertPurpose.SIGNING.storeName(nodeId));
            Certificate agrCert = allPublic.getCertificate(KeyCertPurpose.AGREEMENT.storeName(nodeId));
            if (Stream.of(sigCert).anyMatch(Objects::isNull)) {
                throw new KeyLoadingException("Cannot find certificates for: " + String.valueOf(nodeId));
            }
            sigTrustStore.setCertificateEntry(KeyCertPurpose.SIGNING.storeName(nodeId), sigCert);
            agrTrustStore.setCertificateEntry(KeyCertPurpose.AGREEMENT.storeName(nodeId), agrCert);
        }
        return new PublicStores(sigTrustStore, agrTrustStore);
    }

    public void setCertificate(KeyCertPurpose type, X509Certificate certificate, NodeId nodeId) throws KeyStoreException {
        switch (type) {
            case SIGNING: {
                this.sigTrustStore.setCertificateEntry(type.storeName(nodeId), certificate);
                break;
            }
            case AGREEMENT: {
                this.agrTrustStore.setCertificateEntry(type.storeName(nodeId), certificate);
            }
        }
    }

    public X509Certificate getCertificate(KeyCertPurpose type, NodeId nodeId) throws KeyLoadingException {
        Certificate certificate;
        String name = type.storeName(nodeId);
        try {
            certificate = switch (type) {
                default -> throw new MatchException(null, null);
                case KeyCertPurpose.SIGNING -> this.sigTrustStore.getCertificate(name);
                case KeyCertPurpose.AGREEMENT -> this.agrTrustStore.getCertificate(name);
            };
        }
        catch (KeyStoreException e) {
            throw new CryptographyException((Throwable)e);
        }
        if (certificate == null) {
            throw new KeyLoadingException("Certificate not found", type, nodeId);
        }
        if (certificate instanceof X509Certificate) {
            X509Certificate x509 = (X509Certificate)certificate;
            return x509;
        }
        throw new KeyLoadingException("Certificate is not an instance of X509Certificate", type, nodeId);
    }
}

