/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.test.fixtures.event;

import com.hedera.hapi.platform.event.EventConsensusData;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.test.fixtures.CryptoRandomUtils;
import org.hiero.base.utility.test.fixtures.RandomUtils;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.event.UnsignedEvent;
import org.hiero.consensus.model.node.NodeId;

public class TestingEventBuilder {
    private static final Instant DEFAULT_TIMESTAMP = Instant.ofEpochMilli(1588771316678L);
    private static final NodeId DEFAULT_CREATOR_ID = NodeId.of((long)0L);
    private static final int DEFAULT_APP_TRANSACTION_COUNT = 2;
    private static final int DEFAULT_SYSTEM_TRANSACTION_COUNT = 0;
    private static final int DEFAULT_TRANSACTION_SIZE = 4;
    private final Random random;
    private NodeId creatorId;
    private Instant timeCreated;
    private Integer appTransactionCount;
    private Integer systemTransactionCount;
    private Integer transactionSize;
    private List<Bytes> transactionBytes;
    private PlatformEvent selfParent;
    private List<PlatformEvent> otherParents;
    private Long selfParentBirthRoundOverride;
    private Long otherParentBirthRoundOverride;
    private Long birthRound;
    private Instant consensusTimestamp;
    private Long consensusOrder;
    private long nGen = 0L;

    public TestingEventBuilder(@NonNull Random random) {
        this.random = Objects.requireNonNull(random);
    }

    @NonNull
    public TestingEventBuilder setCreatorId(@Nullable NodeId creatorId) {
        this.creatorId = creatorId;
        return this;
    }

    @NonNull
    public TestingEventBuilder setNGen(long nGen) {
        this.nGen = nGen;
        return this;
    }

    @NonNull
    public TestingEventBuilder setTimeCreated(@Nullable Instant timeCreated) {
        this.timeCreated = timeCreated;
        return this;
    }

    @NonNull
    public TestingEventBuilder setAppTransactionCount(int numberOfAppTransactions) {
        if (this.transactionBytes != null) {
            throw new IllegalStateException("Cannot set app transaction count when transactions are explicitly set");
        }
        this.appTransactionCount = numberOfAppTransactions;
        return this;
    }

    @Deprecated
    @NonNull
    public TestingEventBuilder setSystemTransactionCount(int numberOfSystemTransactions) {
        if (this.transactionBytes != null) {
            throw new IllegalStateException("Cannot set system transaction count when transactions are explicitly set");
        }
        this.systemTransactionCount = numberOfSystemTransactions;
        return this;
    }

    @NonNull
    public TestingEventBuilder setTransactionSize(int transactionSize) {
        if (this.transactionBytes != null) {
            throw new IllegalStateException("Cannot set transaction size when transactions are explicitly set");
        }
        this.transactionSize = transactionSize;
        return this;
    }

    @NonNull
    public TestingEventBuilder setTransactionBytes(@Nullable List<Bytes> transactions) {
        if (this.appTransactionCount != null || this.systemTransactionCount != null || this.transactionSize != null) {
            throw new IllegalStateException("Cannot set transactions when app transaction count, system transaction count, or transaction size are explicitly set");
        }
        this.transactionBytes = transactions;
        return this;
    }

    @NonNull
    public TestingEventBuilder setSelfParent(@Nullable PlatformEvent selfParent) {
        this.selfParent = selfParent;
        return this;
    }

    @NonNull
    public TestingEventBuilder setOtherParent(@Nullable PlatformEvent otherParent) {
        this.otherParents = otherParent == null ? null : List.of(otherParent);
        return this;
    }

    @NonNull
    public TestingEventBuilder setOtherParents(@NonNull List<PlatformEvent> otherParents) {
        this.otherParents = otherParents;
        return this;
    }

    @NonNull
    public TestingEventBuilder overrideSelfParentBirthRound(long birthRound) {
        this.selfParentBirthRoundOverride = birthRound;
        return this;
    }

    @NonNull
    public TestingEventBuilder overrideOtherParentBirthRound(long birthRound) {
        this.otherParentBirthRoundOverride = birthRound;
        return this;
    }

    @NonNull
    public TestingEventBuilder setBirthRound(long birthRound) {
        this.birthRound = birthRound;
        return this;
    }

    @NonNull
    public TestingEventBuilder setConsensusTimestamp(@Nullable Instant consensusTimestamp) {
        this.consensusTimestamp = consensusTimestamp;
        return this;
    }

    @NonNull
    public TestingEventBuilder setConsensusOrder(@Nullable Long consensusOrder) {
        this.consensusOrder = consensusOrder;
        return this;
    }

    @NonNull
    private List<Bytes> generateTransactions() {
        int i;
        if (this.appTransactionCount == null) {
            this.appTransactionCount = 2;
        }
        if (this.systemTransactionCount == null) {
            this.systemTransactionCount = 0;
        }
        ArrayList<Bytes> generatedTransactions = new ArrayList<Bytes>();
        if (this.transactionSize == null) {
            this.transactionSize = 4;
        }
        for (i = 0; i < this.appTransactionCount; ++i) {
            byte[] bytes = new byte[this.transactionSize.intValue()];
            this.random.nextBytes(bytes);
            generatedTransactions.add(Bytes.wrap((byte[])bytes));
        }
        for (i = this.appTransactionCount.intValue(); i < this.appTransactionCount + this.systemTransactionCount; ++i) {
            generatedTransactions.add(StateSignatureTransaction.PROTOBUF.toBytes((Object)StateSignatureTransaction.newBuilder().round(this.random.nextLong(0L, Long.MAX_VALUE)).signature(CryptoRandomUtils.randomSignatureBytes((Random)this.random)).hash(CryptoRandomUtils.randomHashBytes((Random)this.random)).build()));
        }
        return generatedTransactions;
    }

    @Nullable
    private EventDescriptorWrapper createDescriptorFromParent(@Nullable PlatformEvent parent, @Nullable Long birthRoundOverride) {
        if (parent == null) {
            if (birthRoundOverride != null) {
                throw new IllegalArgumentException("Cannot override birth round on a parent that doesn't exist");
            }
            return null;
        }
        if (birthRoundOverride == null) {
            return parent.getDescriptor();
        }
        return new EventDescriptorWrapper(parent.getDescriptor().eventDescriptor().copyBuilder().birthRound(birthRoundOverride.longValue()).build());
    }

    @NonNull
    public PlatformEvent build() {
        if (this.creatorId == null) {
            this.creatorId = this.selfParent != null ? this.selfParent.getCreatorId() : DEFAULT_CREATOR_ID;
        }
        EventDescriptorWrapper selfParentDescriptor = this.createDescriptorFromParent(this.selfParent, this.selfParentBirthRoundOverride);
        List<EventDescriptorWrapper> otherParentDescriptors = Stream.ofNullable(this.otherParents).flatMap(Collection::stream).map(parent -> this.createDescriptorFromParent((PlatformEvent)parent, this.otherParentBirthRoundOverride)).toList();
        if (this.birthRound == null) {
            long maxParentBirthRound = Stream.concat(Stream.ofNullable(this.selfParent), Stream.ofNullable(this.otherParents).flatMap(Collection::stream)).mapToLong(PlatformEvent::getBirthRound).max().orElse(1L);
            this.birthRound = maxParentBirthRound + this.random.nextLong(0L, 3L);
        }
        if (this.timeCreated == null) {
            this.timeCreated = this.selfParent == null ? DEFAULT_TIMESTAMP : this.selfParent.getTimeCreated().plusMillis(this.random.nextLong(1L, 100L));
        }
        if (this.transactionBytes == null) {
            this.transactionBytes = this.generateTransactions();
        }
        UnsignedEvent unsignedEvent = new UnsignedEvent(this.creatorId, selfParentDescriptor, otherParentDescriptors, this.birthRound.longValue(), this.timeCreated, this.transactionBytes, this.random.nextLong(0L, Long.MAX_VALUE));
        byte[] signature = new byte[SignatureType.RSA.signatureLength()];
        this.random.nextBytes(signature);
        PlatformEvent platformEvent = new PlatformEvent(unsignedEvent, Bytes.wrap((byte[])signature));
        platformEvent.setHash(CryptoRandomUtils.randomHash((Random)this.random));
        platformEvent.setNGen(this.nGen);
        if (this.consensusTimestamp != null || this.consensusOrder != null) {
            platformEvent.setConsensusData(new EventConsensusData.Builder().consensusTimestamp(HapiUtils.asTimestamp((Instant)Optional.ofNullable(this.consensusTimestamp).orElse(RandomUtils.randomInstant((Random)this.random)))).consensusOrder(Optional.ofNullable(this.consensusOrder).orElse(this.random.nextLong(1L, Long.MAX_VALUE)).longValue()).build());
        }
        return platformEvent;
    }
}

