/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.config;

import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.virtualmerkle.config.SmartContractConfig;
import com.swirlds.demo.virtualmerkle.config.TransactionRequestConfig;
import java.util.List;

public class VirtualMerkleConfig {
    private List<TransactionRequestConfig> sequential;
    private boolean assorted = false;
    private double samplingProbability = 0.0;
    private SmartContractConfig smartContractConfig;
    private long firstSmartContractId;
    private long firstAccountId;
    private boolean bypassDeleteTransaction = true;

    public List<TransactionRequestConfig> getSequential() {
        return this.sequential;
    }

    public void setSequential(List<TransactionRequestConfig> sequential) {
        this.sequential = sequential;
    }

    public void setSamplingProbability(double samplingProbability) {
        this.samplingProbability = samplingProbability;
    }

    public double getSamplingProbability() {
        return this.samplingProbability;
    }

    public boolean isAssorted() {
        return this.assorted;
    }

    public void setAssorted(boolean assorted) {
        this.assorted = assorted;
    }

    public long getTotalSmartContractCreations() {
        return this.computeTotalAmountOfTransactionsFromType(PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_CREATE_SMART_CONTRACT);
    }

    public long getTotalMethodExecutions() {
        return this.computeTotalAmountOfTransactionsFromType(PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_SMART_CONTRACT_METHOD_EXECUTION);
    }

    public long getTotalAccountCreations() {
        return this.computeTotalAmountOfTransactionsFromType(PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_CREATE);
    }

    public long getMaximumNumberOfKeyValuePairsCreation() {
        if (this.smartContractConfig == null) {
            return 0L;
        }
        long totalSmartContractCreations = this.getTotalSmartContractCreations();
        long totalMethodExecutions = this.getTotalMethodExecutions();
        SmartContractConfig smartContractConfig = this.getSmartContractConfig();
        return totalSmartContractCreations * (long)smartContractConfig.getMaxKeyValuePairsDuringCreation() + totalMethodExecutions * (long)smartContractConfig.getAddsDuringMethodExecution();
    }

    private long computeTotalAmountOfTransactionsFromType(PAYLOAD_TYPE transactionType) {
        return this.sequential.stream().filter(config -> config.getType().equals((Object)transactionType)).map(TransactionRequestConfig::getAmount).reduce(0L, Long::sum);
    }

    public SmartContractConfig getSmartContractConfig() {
        return this.smartContractConfig;
    }

    public void setSmartContractConfig(SmartContractConfig smartContractConfig) {
        this.smartContractConfig = smartContractConfig;
    }

    public long getFirstAccountId() {
        return this.firstAccountId;
    }

    public void setFirstAccountId(long firstAccountId) {
        this.firstAccountId = firstAccountId;
    }

    public long getFirstSmartContractId() {
        return this.firstSmartContractId;
    }

    public void setFirstSmartContractId(long firstSmartContractId) {
        this.firstSmartContractId = firstSmartContractId;
    }

    public boolean isBypassDeleteTransaction() {
        return this.bypassDeleteTransaction;
    }

    public void setBypassDeleteTransaction(boolean bypassDeleteTransaction) {
        this.bypassDeleteTransaction = bypassDeleteTransaction;
    }
}

