/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.emitter;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.emitter.BufferingEventEmitter;
import com.swirlds.platform.test.fixtures.event.generator.GraphGenerator;
import java.util.Queue;
import java.util.Random;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class ShuffledEventEmitter
extends BufferingEventEmitter {
    private Random random;
    private final long initialSeed;

    public ShuffledEventEmitter(GraphGenerator graphGenerator, long seed) {
        super(graphGenerator);
        this.initialSeed = seed;
        this.random = new Random(seed);
    }

    private ShuffledEventEmitter(ShuffledEventEmitter that) {
        this(that.getGraphGenerator().cleanCopy(), that.initialSeed);
        this.setCheckpoint(that.getCheckpoint());
    }

    private ShuffledEventEmitter(ShuffledEventEmitter that, long seed) {
        this(that.getGraphGenerator().cleanCopy(), seed);
        this.setCheckpoint(that.getCheckpoint());
    }

    @Override
    public EventImpl emitEvent() {
        int attempts = 0;
        do {
            int nodeIndex = this.random.nextInt(this.getGraphGenerator().getNumberOfSources());
            NodeId nodeID = RosterUtils.getNodeId((Roster)this.getGraphGenerator().getRoster(), (int)nodeIndex);
            this.attemptToGenerateEventFromNode(nodeID);
            if (!this.isReadyToEmitEvent(nodeID)) continue;
            this.eventEmittedFromBuffer();
            return (EventImpl)((Queue)this.events.get(nodeID)).remove();
        } while (++attempts <= 1000);
        throw new RuntimeException("Cannot find event to emit");
    }

    @Override
    public ShuffledEventEmitter cleanCopy() {
        return new ShuffledEventEmitter(this);
    }

    @Override
    public ShuffledEventEmitter cleanCopy(long seed) {
        return new ShuffledEventEmitter(this, seed);
    }

    @Override
    public void reset() {
        super.reset();
        this.random = new Random(this.initialSeed);
    }
}

