/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SignatureObject;
import com.hedera.hapi.streams.SignatureType;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class SignatureObjectJsonCodec
implements JsonCodec<SignatureObject> {
    @NonNull
    public SignatureObject parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            SignatureType temp_type = SignatureType.fromProtobufOrdinal(0);
            int temp_length = 0;
            int temp_checksum = 0;
            Bytes temp_signature = Bytes.EMPTY;
            HashObject temp_hash_object = null;
            block16: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "type": {
                        temp_type = SignatureType.fromString(kvPair.value().STRING().getText());
                        continue block16;
                    }
                    case "length": {
                        temp_length = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block16;
                    }
                    case "checksum": {
                        temp_checksum = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block16;
                    }
                    case "signature": {
                        temp_signature = Bytes.fromBase64((String)JsonTools.checkSize((String)"signature", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block16;
                    }
                    case "hashObject": {
                        temp_hash_object = (HashObject)HashObject.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block16;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new SignatureObject(temp_type, temp_length, temp_checksum, temp_signature, temp_hash_object);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull SignatureObject data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.type() != SignatureType.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"type", (String)data.type().protoName()));
        }
        if (data.length() != 0) {
            fieldLines.add(JsonTools.field((String)"length", (int)data.length()));
        }
        if (data.checksum() != 0) {
            fieldLines.add(JsonTools.field((String)"checksum", (int)data.checksum()));
        }
        if (data.signature() != Bytes.EMPTY && data.signature() != null && data.signature().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"signature", (Bytes)data.signature()));
        }
        if (data.hashObject() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"hashObject", HashObject.JSON, (Object)data.hashObject()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

