/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.util.IterableUtil;

public class ShouldContainExactlyInAnyOrder
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainExactlyInAnyOrder(Object actual, Object expected, Iterable<?> notFound, Iterable<?> notExpected, ComparisonStrategy comparisonStrategy) {
        if (IterableUtil.isNullOrEmpty(notExpected)) {
            return new ShouldContainExactlyInAnyOrder(actual, expected, notFound, ErrorType.NOT_FOUND_ONLY, comparisonStrategy);
        }
        if (IterableUtil.isNullOrEmpty(notFound)) {
            return new ShouldContainExactlyInAnyOrder(actual, expected, notExpected, ErrorType.NOT_EXPECTED_ONLY, comparisonStrategy);
        }
        return new ShouldContainExactlyInAnyOrder(actual, expected, notFound, notExpected, comparisonStrategy);
    }

    private ShouldContainExactlyInAnyOrder(Object actual, Object expected, Iterable<?> notFound, Iterable<?> notExpected, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting actual:%n  %s%nto contain exactly in any order:%n  %s%nelements not found:%n  %s%nand elements not expected:%n  %s%n%s", actual, expected, notFound, notExpected, comparisonStrategy);
    }

    private ShouldContainExactlyInAnyOrder(Object actual, Object expected, Iterable<?> notFoundOrNotExpected, ErrorType errorType, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting actual:%n  %s%nto contain exactly in any order:%n  %s%n" + (errorType == ErrorType.NOT_FOUND_ONLY ? "but could not find the following elements:%n" : "but the following elements were unexpected:%n") + "  %s%n%s", actual, expected, notFoundOrNotExpected, comparisonStrategy);
    }

    public static enum ErrorType {
        NOT_FOUND_ONLY,
        NOT_EXPECTED_ONLY;

    }
}

