/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.generator;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.DynamicValue;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.hiero.consensus.model.node.NodeId;

public interface GraphGenerator {
    public EventImpl generateEvent();

    public int getNumberOfSources();

    public EventSource getSource(@NonNull NodeId var1);

    @NonNull
    public EventSource getSourceByIndex(int var1);

    default public GraphGenerator copy() {
        GraphGenerator generator = this.cleanCopy();
        generator.skip(this.getNumEventsGenerated());
        return generator;
    }

    public GraphGenerator cleanCopy();

    public void reset();

    public long getNumEventsGenerated();

    default public void skip(long numberToSkip) {
        for (long i = 0L; i < numberToSkip; ++i) {
            this.generateEvent();
        }
    }

    default public List<EventImpl> generateEvents(int numberOfEvents) {
        ArrayList<EventImpl> events = new ArrayList<EventImpl>(numberOfEvents);
        for (int i = 0; i < numberOfEvents; ++i) {
            events.add(this.generateEvent());
        }
        return events;
    }

    @NonNull
    public Roster getRoster();

    public long getMaxBirthRound(@Nullable NodeId var1);

    public void setOtherParentAffinity(List<List<Double>> var1);

    public void setOtherParentAffinity(DynamicValue<List<List<Double>>> var1);

    public void removeNode(@NonNull NodeId var1);
}

