/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.test.fixtures.consensus.TestIntake;
import com.swirlds.platform.test.fixtures.consensus.framework.ConsensusOutput;
import com.swirlds.platform.test.fixtures.event.emitter.EventEmitter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;

public class ConsensusTestNode {
    private final EventEmitter eventEmitter;
    private final TestIntake intake;
    private final Random random;

    public ConsensusTestNode(@NonNull EventEmitter eventEmitter, @NonNull TestIntake intake) {
        this.eventEmitter = eventEmitter;
        this.intake = intake;
        this.random = new Random();
    }

    @NonNull
    public static ConsensusTestNode genesisContext(@NonNull PlatformContext platformContext, @NonNull EventEmitter eventEmitter) {
        return new ConsensusTestNode(eventEmitter, new TestIntake(Objects.requireNonNull(platformContext), eventEmitter.getGraphGenerator().getRoster()));
    }

    public void restart() {
        this.eventEmitter.reset();
        ConsensusSnapshot snapshot = Objects.requireNonNull(this.getOutput().getConsensusRounds().peekLast()).getSnapshot();
        this.intake.reset();
        this.intake.loadSnapshot(snapshot);
    }

    public void removeNode(@NonNull NodeId nodeId) {
        this.eventEmitter.getGraphGenerator().removeNode(nodeId);
        ConsensusSnapshot snapshot = Objects.requireNonNull(this.getOutput().getConsensusRounds().peekLast()).getSnapshot();
        this.intake.loadSnapshot(snapshot);
        LinkedList<PlatformEvent> added = new LinkedList<PlatformEvent>(this.getOutput().getAddedEvents());
        this.getOutput().getAddedEvents().clear();
        for (PlatformEvent e : added) {
            this.intake.addEvent(e.copyGossipedData());
        }
    }

    @NonNull
    public ConsensusTestNode reconnect(@NonNull PlatformContext platformContext) {
        EventEmitter newEmitter = this.eventEmitter.cleanCopy(this.random.nextLong());
        newEmitter.reset();
        ConsensusTestNode consensusTestNode = new ConsensusTestNode(newEmitter, new TestIntake(platformContext, newEmitter.getGraphGenerator().getRoster()));
        consensusTestNode.intake.loadSnapshot(Objects.requireNonNull(this.getOutput().getConsensusRounds().peekLast()).getSnapshot());
        ((ListAssert)Assertions.assertThat(consensusTestNode.intake.getConsensusRounds()).withFailMessage("we should not have reached consensus yet", new Object[0])).isEmpty();
        return consensusTestNode;
    }

    public void addEvents(long numberOfEvents) {
        int i = 0;
        while ((long)i < numberOfEvents) {
            this.intake.addEvent(this.eventEmitter.emitEvent().getBaseEvent());
            ++i;
        }
    }

    @NonNull
    public EventEmitter getEventEmitter() {
        return this.eventEmitter;
    }

    public long getLatestRound() {
        return this.intake.getOutput().getLatestRound();
    }

    @NonNull
    public ConsensusOutput getOutput() {
        return this.intake.getOutput();
    }

    @NonNull
    public TestIntake getIntake() {
        return this.intake;
    }

    @NonNull
    public Random getRandom() {
        return this.random;
    }
}

