/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.tipset;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.common.utility.Threshold;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.event.creator.EventCreationConfig;
import org.hiero.consensus.event.creator.impl.tipset.ChildlessEventTracker;
import org.hiero.consensus.event.creator.impl.tipset.Tipset;
import org.hiero.consensus.event.creator.impl.tipset.TipsetAdvancementWeight;
import org.hiero.consensus.event.creator.impl.tipset.TipsetTracker;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class TipsetWeightCalculator {
    private static final Logger logger = LogManager.getLogger(TipsetWeightCalculator.class);
    private final NodeId selfId;
    private final TipsetTracker tipsetTracker;
    private final ChildlessEventTracker childlessEventTracker;
    private Tipset snapshot;
    private final Deque<Tipset> snapshotHistory = new LinkedList<Tipset>();
    private final int maxSnapshotHistorySize;
    private final long totalWeight;
    private final long selfWeight;
    private final long maximumPossibleAdvancementWeight;
    private TipsetAdvancementWeight previousAdvancementWeight = TipsetAdvancementWeight.ZERO_ADVANCEMENT_WEIGHT;
    private Tipset latestSelfEventTipset;
    private final Roster roster;
    private final RateLimitedLogger ancientParentLogger;
    private final RateLimitedLogger allParentsAreAncientLogger;

    public TipsetWeightCalculator(@NonNull Configuration configuration, @NonNull Time time, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull TipsetTracker tipsetTracker, @NonNull ChildlessEventTracker childlessEventTracker) {
        this.selfId = Objects.requireNonNull(selfId);
        this.tipsetTracker = Objects.requireNonNull(tipsetTracker);
        this.childlessEventTracker = Objects.requireNonNull(childlessEventTracker);
        this.roster = Objects.requireNonNull(roster);
        this.totalWeight = RosterUtils.computeTotalWeight((Roster)roster);
        this.selfWeight = RosterUtils.getRosterEntry((Roster)roster, (long)selfId.id()).weight();
        this.maximumPossibleAdvancementWeight = this.totalWeight - this.selfWeight;
        this.maxSnapshotHistorySize = ((EventCreationConfig)configuration.getConfigData(EventCreationConfig.class)).tipsetSnapshotHistorySize();
        this.latestSelfEventTipset = this.snapshot = new Tipset(roster);
        this.snapshotHistory.add(this.snapshot);
        this.ancientParentLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.allParentsAreAncientLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
    }

    public long getMaximumPossibleAdvancementWeight() {
        return this.maximumPossibleAdvancementWeight;
    }

    @NonNull
    public Tipset getSnapshot() {
        return this.snapshot;
    }

    public TipsetAdvancementWeight addEventAndGetAdvancementWeight(@NonNull EventDescriptorWrapper event) {
        Objects.requireNonNull(event);
        if (!event.creator().equals((Object)this.selfId)) {
            throw new IllegalArgumentException("event creator must be the same as self ID");
        }
        Tipset eventTipset = this.tipsetTracker.getTipset(event);
        if (eventTipset == null) {
            throw new IllegalArgumentException("event " + String.valueOf(event) + " is not in the tipset tracker");
        }
        TipsetAdvancementWeight advancementWeight = this.snapshot.getTipAdvancementWeight(this.selfId, eventTipset);
        if (advancementWeight.advancementWeight() > this.maximumPossibleAdvancementWeight) {
            throw new IllegalStateException("advancement weight " + String.valueOf(advancementWeight) + " is greater than the maximum possible weight " + this.maximumPossibleAdvancementWeight);
        }
        TipsetAdvancementWeight advancementWeightImprovement = advancementWeight.minus(this.previousAdvancementWeight);
        if (Threshold.SUPER_MAJORITY.isSatisfiedBy(advancementWeight.advancementWeight() + this.selfWeight, this.totalWeight)) {
            this.snapshot = eventTipset;
            this.snapshotHistory.add(this.snapshot);
            if (this.snapshotHistory.size() > this.maxSnapshotHistorySize) {
                this.snapshotHistory.remove();
            }
            this.previousAdvancementWeight = TipsetAdvancementWeight.ZERO_ADVANCEMENT_WEIGHT;
        } else {
            this.previousAdvancementWeight = advancementWeight;
        }
        this.latestSelfEventTipset = eventTipset;
        return advancementWeightImprovement;
    }

    public TipsetAdvancementWeight getTheoreticalAdvancementWeight(@NonNull List<EventDescriptorWrapper> parents) {
        if (parents.isEmpty()) {
            return TipsetAdvancementWeight.ZERO_ADVANCEMENT_WEIGHT;
        }
        ArrayList<Tipset> parentTipsets = new ArrayList<Tipset>(parents.size());
        for (EventDescriptorWrapper parent : parents) {
            Tipset parentTipset = this.tipsetTracker.getTipset(parent);
            if (parentTipset == null) {
                if (parent.creator().equals((Object)this.selfId)) continue;
                this.ancientParentLogger.error(LogMarker.EXCEPTION.getMarker(), "When looking at possible parents, we should never consider ancient parents that are not self parents. Parent ID = {}, parent ancient threshold = {}, minimum threshold non-ancient = {}", new Object[]{parent.creator(), parent.birthRound(), this.tipsetTracker.getEventWindow()});
                continue;
            }
            parentTipsets.add(parentTipset);
        }
        if (parentTipsets.isEmpty()) {
            this.allParentsAreAncientLogger.error(LogMarker.EXCEPTION.getMarker(), "all parents being considered are ancient", new Object[0]);
            return TipsetAdvancementWeight.ZERO_ADVANCEMENT_WEIGHT;
        }
        Tipset newTipset = new Tipset(this.roster).merge(parentTipsets);
        return this.snapshot.getTipAdvancementWeight(this.selfId, newTipset).minus(this.previousAdvancementWeight);
    }

    public int getMaxSelfishnessScore() {
        int selfishness = 0;
        for (PlatformEvent event : this.childlessEventTracker.getChildlessEvents()) {
            selfishness = Math.max(selfishness, this.getSelfishnessScoreForNode(event.getCreatorId()));
        }
        return selfishness;
    }

    public int getSelfishnessScoreForNode(@NonNull NodeId nodeId) {
        if (this.latestSelfEventTipset == null) {
            return 0;
        }
        if (this.latestSelfEventTipset.getTipGenerationForNode(nodeId) > this.snapshotHistory.getLast().getTipGenerationForNode(nodeId)) {
            return 0;
        }
        int selfishness = 0;
        long latestGeneration = this.tipsetTracker.getLatestGenerationForNode(nodeId);
        Iterator<Tipset> iterator = this.snapshotHistory.descendingIterator();
        Tipset previousTipset = iterator.next();
        while (iterator.hasNext()) {
            Tipset currentTipset = previousTipset;
            previousTipset = iterator.next();
            long previousGeneration = previousTipset.getTipGenerationForNode(nodeId);
            long currentGeneration = currentTipset.getTipGenerationForNode(nodeId);
            if (currentGeneration == latestGeneration || previousGeneration < currentGeneration) break;
            ++selfishness;
        }
        return selfishness;
    }

    public void clear() {
        this.latestSelfEventTipset = this.snapshot = new Tipset(this.roster);
        this.snapshotHistory.clear();
        this.snapshotHistory.add(this.snapshot);
        this.previousAdvancementWeight = TipsetAdvancementWeight.ZERO_ADVANCEMENT_WEIGHT;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Total weight: ").append(this.totalWeight).append("\n");
        sb.append("Maximum possible advancement weight: ").append(this.maximumPossibleAdvancementWeight).append("\n");
        sb.append("Self weight: ").append(this.selfWeight).append("\n");
        sb.append("Previous advancement weight: ").append(this.previousAdvancementWeight).append("\n");
        sb.append("Latest self event tipset: ").append(this.latestSelfEventTipset).append("\n");
        sb.append("Snapshot: ").append(this.snapshot).append("\n");
        sb.append("Snapshot history: ").append("\n");
        for (Tipset tipset : this.snapshotHistory) {
            sb.append("  - ").append(tipset).append("\n");
        }
        return sb.toString();
    }
}

