/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.internal.network.Network;
import com.hedera.node.internal.network.NodeMetadata;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.State;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hiero.base.crypto.CryptoUtils;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.ReadableRosterStoreImpl;
import org.hiero.consensus.roster.RosterEntryNotFoundException;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.roster.WritableRosterStore;
import org.hiero.consensus.roster.internal.PbjRecordHasher;

public final class RosterUtils {
    private static final PbjRecordHasher PBJ_RECORD_HASHER = new PbjRecordHasher();

    private RosterUtils() {
    }

    @NonNull
    public static String formatNodeName(long nodeId) {
        return "node" + (nodeId + 1L);
    }

    @NonNull
    public static String formatNodeName(@NonNull NodeId nodeId) {
        return RosterUtils.formatNodeName(nodeId.id());
    }

    public static X509Certificate fetchGossipCaCertificate(@NonNull RosterEntry entry) {
        try {
            return CryptoUtils.decodeCertificate((byte[])entry.gossipCaCertificate().toByteArray());
        }
        catch (CryptographyException e) {
            return null;
        }
    }

    public static boolean isWeightRotation(@NonNull Roster from, @NonNull Roster to) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Set fromNodes = from.rosterEntries().stream().map(RosterEntry::nodeId).collect(Collectors.toSet());
        Set toNodes = to.rosterEntries().stream().map(RosterEntry::nodeId).collect(Collectors.toSet());
        return fromNodes.equals(toNodes);
    }

    public static String fetchHostname(@NonNull RosterEntry entry, int index) {
        ServiceEndpoint serviceEndpoint = (ServiceEndpoint)entry.gossipEndpoint().get(index);
        Bytes ipAddressV4 = serviceEndpoint.ipAddressV4();
        long length = ipAddressV4.length();
        if (length == 0L) {
            return serviceEndpoint.domainName();
        }
        if (length == 4L) {
            return HapiUtils.asReadableIp((Bytes)ipAddressV4);
        }
        throw new IllegalArgumentException("Invalid IP address: " + String.valueOf(ipAddressV4) + " in RosterEntry: " + String.valueOf(entry));
    }

    public static int fetchPort(@NonNull RosterEntry entry, int index) {
        ServiceEndpoint serviceEndpoint = (ServiceEndpoint)entry.gossipEndpoint().get(index);
        return serviceEndpoint.port();
    }

    @NonNull
    public static Hash hash(@NonNull Roster roster) {
        return PBJ_RECORD_HASHER.hash(roster, Roster.PROTOBUF);
    }

    @Nullable
    public static Map<Long, RosterEntry> toMap(@Nullable Roster roster) {
        if (roster == null) {
            return null;
        }
        return roster.rosterEntries().stream().collect(Collectors.toMap(RosterEntry::nodeId, Function.identity()));
    }

    public static Map<Long, Integer> toIndicesMap(@NonNull Roster roster) {
        return IntStream.range(0, roster.rosterEntries().size()).boxed().collect(Collectors.toMap(i -> ((RosterEntry)roster.rosterEntries().get((int)i)).nodeId(), Function.identity()));
    }

    public static int getIndex(@NonNull Roster roster, long nodeId) {
        for (int i = 0; i < roster.rosterEntries().size(); ++i) {
            if (((RosterEntry)roster.rosterEntries().get(i)).nodeId() != nodeId) continue;
            return i;
        }
        return -1;
    }

    public static long computeTotalWeight(@NonNull Roster roster) {
        return roster.rosterEntries().stream().mapToLong(RosterEntry::weight).sum();
    }

    public static RosterEntry getRosterEntry(@NonNull Roster roster, long nodeId) {
        RosterEntry entry = RosterUtils.getRosterEntryOrNull(roster, nodeId);
        if (entry != null) {
            return entry;
        }
        throw new RosterEntryNotFoundException("No RosterEntry with nodeId: " + nodeId + " in Roster: " + String.valueOf(roster));
    }

    @NonNull
    public static NodeId getNodeId(@NonNull Roster roster, int nodeIndex) {
        return NodeId.of((long)((RosterEntry)Objects.requireNonNull(roster).rosterEntries().get(nodeIndex)).nodeId());
    }

    public static NodeId getNodeId(@NonNull RosterEntry rosterEntry) {
        return NodeId.of((long)rosterEntry.nodeId());
    }

    public static RosterEntry getRosterEntryOrNull(@NonNull Roster roster, long nodeId) {
        Objects.requireNonNull(roster, "roster");
        for (RosterEntry entry : roster.rosterEntries()) {
            if (entry.nodeId() != nodeId) continue;
            return entry;
        }
        return null;
    }

    public static int getNumberWithWeight(@NonNull Roster roster) {
        return (int)roster.rosterEntries().stream().map(RosterEntry::weight).filter(w -> w != 0L).count();
    }

    @NonNull
    public static RosterHistory createRosterHistory(@NonNull State state) {
        ReadableRosterStoreImpl rosterStore = new ReadableRosterStoreImpl(state.getReadableStates("RosterService"));
        List<RoundRosterPair> roundRosterPairs = rosterStore.getRosterHistory();
        HashMap<Bytes, Roster> rosterMap = new HashMap<Bytes, Roster>();
        for (RoundRosterPair pair : roundRosterPairs) {
            rosterMap.put(pair.activeRosterHash(), Objects.requireNonNull(rosterStore.get(pair.activeRosterHash())));
        }
        return new RosterHistory(roundRosterPairs, rosterMap);
    }

    public static void setActiveRoster(@NonNull State state, @NonNull Roster roster, long round) {
        WritableStates writableStates = state.getWritableStates("RosterService");
        WritableRosterStore writableRosterStore = new WritableRosterStore(writableStates);
        writableRosterStore.putActiveRoster(roster, round);
        ((CommittableWritableStates)writableStates).commit();
    }

    @Nullable
    public static String toString(@Nullable Roster roster) {
        return roster == null ? null : Roster.JSON.toJSON((Object)roster);
    }

    @Deprecated(forRemoval=true)
    @NonNull
    public static Address buildAddress(@NonNull RosterEntry entry) {
        X509Certificate sigCert;
        Address address = new Address();
        address = address.copySetNodeId(NodeId.of((long)entry.nodeId()));
        address = address.copySetWeight(entry.weight());
        try {
            sigCert = CryptoUtils.decodeCertificate((byte[])entry.gossipCaCertificate().toByteArray());
        }
        catch (CryptographyException e) {
            sigCert = null;
        }
        address = address.copySetSigCert(sigCert);
        if (entry.gossipEndpoint().size() > 0) {
            address = address.copySetHostnameExternal(RosterUtils.fetchHostname(entry, 0));
            address = address.copySetPortExternal(RosterUtils.fetchPort(entry, 0));
            if (entry.gossipEndpoint().size() > 1) {
                address = address.copySetHostnameInternal(RosterUtils.fetchHostname(entry, 1));
                address = address.copySetPortInternal(RosterUtils.fetchPort(entry, 1));
            } else {
                address = address.copySetHostnameInternal(RosterUtils.fetchHostname(entry, 0));
                address = address.copySetPortInternal(RosterUtils.fetchPort(entry, 0));
            }
        }
        String name = RosterUtils.formatNodeName(entry.nodeId());
        address = address.copySetSelfName(name).copySetNickname(name);
        return address;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static AddressBook buildAddressBook(@Nullable Roster roster) {
        if (roster == null) {
            return null;
        }
        AddressBook addressBook = new AddressBook();
        for (RosterEntry entry : roster.rosterEntries()) {
            addressBook = addressBook.add(RosterUtils.buildAddress(entry));
        }
        return addressBook;
    }

    @NonNull
    public static Roster rosterFrom(@NonNull Network network) {
        return new Roster(network.nodeMetadata().stream().map(NodeMetadata::rosterEntryOrThrow).toList());
    }
}

