/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.graph;

import com.swirlds.platform.test.fixtures.event.emitter.EventEmitter;
import com.swirlds.platform.test.fixtures.event.generator.GraphGenerator;
import com.swirlds.platform.test.fixtures.graph.OtherParentMatrixFactory;
import com.swirlds.platform.test.fixtures.sync.SyncNode;
import java.util.List;

public class PartitionedGraphCreator {
    public static void setupPartitionForNode(SyncNode node, List<Integer> nodesInPartition, int numCommonEvents, int numNetworkNodes) {
        EventEmitter emitter = node.getEmitter();
        GraphGenerator graphGenerator = emitter.getGraphGenerator();
        List<List<Double>> fullyConnectedMatrix = OtherParentMatrixFactory.createBalancedOtherParentMatrix(numNetworkNodes);
        List<List<Double>> partitionedOtherMatrix = OtherParentMatrixFactory.createPartitionedOtherParentAffinityMatrix(numNetworkNodes, nodesInPartition);
        for (int i = 0; i < graphGenerator.getNumberOfSources(); ++i) {
            boolean isSourceInPartition = nodesInPartition.contains(i);
            graphGenerator.getSourceByIndex(i).setNewEventWeight((r, index, prev) -> {
                if (index < (long)numCommonEvents || isSourceInPartition) {
                    return 1.0;
                }
                return 0.0;
            });
        }
        graphGenerator.setOtherParentAffinity((r, eventIndex, previousValue) -> {
            if (eventIndex < (long)numCommonEvents) {
                return fullyConnectedMatrix;
            }
            return partitionedOtherMatrix;
        });
    }
}

