/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.junit.jupiter;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.assertj.core.annotations.Beta;
import org.assertj.core.api.AbstractSoftAssertions;
import org.assertj.core.api.AssertionErrorCollector;
import org.assertj.core.api.DefaultAssertionErrorCollector;
import org.assertj.core.api.SoftAssertionsProvider;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.platform.commons.annotation.Testable;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class SoftAssertionsExtension
implements TestInstancePostProcessor,
BeforeEachCallback,
ParameterResolver,
AfterTestExecutionCallback {
    private static final ExtensionContext.Namespace SOFT_ASSERTIONS_EXTENSION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SoftAssertionsExtension.class});

    static boolean isPerClass(ExtensionContext context) {
        return context.getTestInstanceLifecycle().map(x -> x == TestInstance.Lifecycle.PER_CLASS).orElse(false);
    }

    static boolean isAnnotatedConcurrent(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), Execution.class).map(Execution::value).map(x -> x == ExecutionMode.CONCURRENT).orElse(false);
    }

    static boolean isPerClassConcurrent(ExtensionContext context) {
        return SoftAssertionsExtension.isPerClass(context) && SoftAssertionsExtension.isAnnotatedConcurrent(context);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        List softAssertionsFields = ReflectionSupport.findFields(testInstance.getClass(), field -> AnnotationSupport.isAnnotated((AnnotatedElement)field, InjectSoftAssertions.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        for (Field softAssertionsField : softAssertionsFields) {
            SoftAssertionsExtension.checkIsNotStaticOrFinal(softAssertionsField);
            Class<? extends SoftAssertionsProvider> softAssertionsProviderClass = SoftAssertionsExtension.asSoftAssertionsProviderClass(softAssertionsField, softAssertionsField.getType());
            SoftAssertionsExtension.checkIsNotAbstract(softAssertionsField, softAssertionsProviderClass);
            SoftAssertionsExtension.checkHasDefaultConstructor(softAssertionsField, softAssertionsProviderClass);
            SoftAssertionsProvider softAssertions = SoftAssertionsExtension.getSoftAssertionsProvider(context, softAssertionsProviderClass);
            SoftAssertionsExtension.setTestInstanceSoftAssertionsField(testInstance, softAssertionsField, softAssertions);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        AssertionErrorCollector collector = SoftAssertionsExtension.getAssertionErrorCollector(context);
        if (SoftAssertionsExtension.isPerClassConcurrent(context)) {
            ThreadLocalErrorCollector tlec = SoftAssertionsExtension.getThreadLocalCollector(context);
            tlec.setDelegate(collector);
        } else {
            while (SoftAssertionsExtension.initialiseDelegate(context, collector) && context.getParent().isPresent()) {
                context = (ExtensionContext)context.getParent().get();
            }
        }
    }

    private static boolean initialiseDelegate(ExtensionContext context, AssertionErrorCollector collector) {
        Collection<SoftAssertionsProvider> providers = SoftAssertionsExtension.getSoftAssertionsProviders(context);
        if (providers == null) {
            return false;
        }
        providers.forEach(x -> x.setDelegate(collector));
        return context.getParent().isPresent();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean isTestableMethod;
        if (SoftAssertionsExtension.isUnsupportedParameterType(parameterContext.getParameter())) {
            return false;
        }
        Executable executable = parameterContext.getDeclaringExecutable();
        boolean bl = isTestableMethod = executable instanceof Method && AnnotationSupport.isAnnotated((AnnotatedElement)executable, Testable.class);
        if (!isTestableMethod) {
            throw new ParameterResolutionException(String.format("Configuration error: cannot resolve SoftAssertionsProvider instances for [%s]. Only test methods are supported.", executable));
        }
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (Modifier.isAbstract(parameterType.getModifiers())) {
            throw new ParameterResolutionException(String.format("Configuration error: the resolved SoftAssertionsProvider implementation [%s] is abstract and cannot be instantiated.", executable));
        }
        try {
            parameterType.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new ParameterResolutionException(String.format("Configuration error: the resolved SoftAssertionsProvider implementation [%s] has no default constructor and cannot be instantiated.", executable));
        }
        return true;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> concreteSoftAssertionsProviderType = parameterContext.getParameter().getType();
        SoftAssertionsProvider provider = (SoftAssertionsProvider)ReflectionSupport.newInstance(concreteSoftAssertionsProviderType, (Object[])new Object[0]);
        provider.setDelegate(SoftAssertionsExtension.getAssertionErrorCollector(extensionContext));
        return provider;
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        AssertionErrorCollector collector;
        if (SoftAssertionsExtension.isPerClassConcurrent(extensionContext)) {
            ThreadLocalErrorCollector tlec = SoftAssertionsExtension.getThreadLocalCollector(extensionContext);
            collector = tlec.getDelegate().orElseThrow(() -> new IllegalStateException("Expecting delegate to be present for current context"));
            tlec.reset();
        } else {
            collector = SoftAssertionsExtension.getAssertionErrorCollector(extensionContext);
        }
        AbstractSoftAssertions.assertAll(collector);
    }

    private static boolean isUnsupportedParameterType(Parameter parameter) {
        Class<?> type = parameter.getType();
        return !SoftAssertionsProvider.class.isAssignableFrom(type);
    }

    private static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(SOFT_ASSERTIONS_EXTENSION_NAMESPACE);
    }

    private static ThreadLocalErrorCollector getThreadLocalCollector(ExtensionContext context) {
        return (ThreadLocalErrorCollector)SoftAssertionsExtension.getStore(context).getOrComputeIfAbsent(ThreadLocalErrorCollector.class, unused -> new ThreadLocalErrorCollector(), ThreadLocalErrorCollector.class);
    }

    @Beta
    public static AssertionErrorCollector getAssertionErrorCollector(ExtensionContext context) {
        return (AssertionErrorCollector)SoftAssertionsExtension.getStore(context).getOrComputeIfAbsent(AssertionErrorCollector.class, unused -> new DefaultAssertionErrorCollector(), AssertionErrorCollector.class);
    }

    private static Collection<SoftAssertionsProvider> getSoftAssertionsProviders(ExtensionContext context) {
        return (Collection)SoftAssertionsExtension.getStore(context).getOrComputeIfAbsent(Collection.class, unused -> new ConcurrentLinkedQueue(), Collection.class);
    }

    private static <T extends SoftAssertionsProvider> T instantiateProvider(ExtensionContext context, Class<T> providerType) {
        SoftAssertionsProvider softAssertions = (SoftAssertionsProvider)ReflectionSupport.newInstance(providerType, (Object[])new Object[0]);
        if (SoftAssertionsExtension.isPerClassConcurrent(context)) {
            softAssertions.setDelegate(SoftAssertionsExtension.getThreadLocalCollector(context));
        } else if (context.getTestMethod().isPresent()) {
            softAssertions.setDelegate(SoftAssertionsExtension.getAssertionErrorCollector(context));
        }
        SoftAssertionsExtension.getSoftAssertionsProviders(context).add(softAssertions);
        return (T)softAssertions;
    }

    @Beta
    public static <T extends SoftAssertionsProvider> T getSoftAssertionsProvider(ExtensionContext context, Class<T> concreteSoftAssertionsProviderType) {
        return (T)((SoftAssertionsProvider)SoftAssertionsExtension.getStore(context).getOrComputeIfAbsent(concreteSoftAssertionsProviderType, unused -> SoftAssertionsExtension.instantiateProvider(context, concreteSoftAssertionsProviderType), concreteSoftAssertionsProviderType));
    }

    private static void setTestInstanceSoftAssertionsField(Object testInstance, Field softAssertionsField, SoftAssertionsProvider softAssertions) {
        softAssertionsField.setAccessible(true);
        try {
            softAssertionsField.set(testInstance, softAssertions);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionConfigurationException(String.format("[%s] Could not gain access to field", softAssertionsField.getName()), (Throwable)e);
        }
    }

    private static void checkHasDefaultConstructor(Field softAssertionsField, Class<? extends SoftAssertionsProvider> softAssertionsProviderClass) {
        try {
            softAssertionsProviderClass.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new ExtensionConfigurationException(String.format("[%s] SoftAssertionsProvider [%s] does not have a default constructor", softAssertionsField.getName(), softAssertionsProviderClass.getName()));
        }
    }

    private static void checkIsNotAbstract(Field softAssertionsField, Class<? extends SoftAssertionsProvider> softAssertionsProviderClass) {
        if (Modifier.isAbstract(softAssertionsProviderClass.getModifiers())) {
            throw new ExtensionConfigurationException(String.format("[%s] SoftAssertionsProvider [%s] is abstract and cannot be instantiated.", softAssertionsField.getName(), softAssertionsProviderClass));
        }
    }

    private static Class<? extends SoftAssertionsProvider> asSoftAssertionsProviderClass(Field softAssertionsField, Class<?> providerClass) {
        if (!SoftAssertionsProvider.class.isAssignableFrom(providerClass)) {
            throw new ExtensionConfigurationException(String.format("[%s] field is not a SoftAssertionsProvider (%s).", softAssertionsField.getName(), providerClass.getTypeName()));
        }
        return providerClass;
    }

    private static void checkIsNotStaticOrFinal(Field softAssertionsField) {
        int fieldModifiers = softAssertionsField.getModifiers();
        if (Modifier.isStatic(fieldModifiers) || Modifier.isFinal(fieldModifiers)) {
            throw new ExtensionConfigurationException(String.format("[%s] SoftAssertionsProvider field must not be static or final.", softAssertionsField.getName()));
        }
    }

    static class ThreadLocalErrorCollector
    implements AssertionErrorCollector {
        InheritableThreadLocal<AssertionErrorCollector> threadLocal = new InheritableThreadLocal();

        ThreadLocalErrorCollector() {
        }

        @Override
        public Optional<AssertionErrorCollector> getDelegate() {
            return Optional.of((AssertionErrorCollector)this.threadLocal.get());
        }

        @Override
        public void setDelegate(AssertionErrorCollector assertionErrorCollector) {
            this.threadLocal.set(assertionErrorCollector);
        }

        public void reset() {
            this.threadLocal.remove();
        }

        @Override
        public void collectAssertionError(AssertionError assertionError) {
            ((AssertionErrorCollector)this.threadLocal.get()).collectAssertionError(assertionError);
        }

        @Override
        public List<AssertionError> assertionErrorsCollected() {
            return ((AssertionErrorCollector)this.threadLocal.get()).assertionErrorsCollected();
        }

        @Override
        public void succeeded() {
            ((AssertionErrorCollector)this.threadLocal.get()).succeeded();
        }

        @Override
        public boolean wasSuccess() {
            return ((AssertionErrorCollector)this.threadLocal.get()).wasSuccess();
        }
    }
}

