/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.model;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gui.model.WordList;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Reference {
    private byte[] data;
    private static final String digits = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Logger logger = LogManager.getLogger(Reference.class);
    private static final double LOG_2 = Math.log(2.0);

    public Reference(byte[] data) {
        byte crc;
        if (data == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "data should not be null");
            throw new InvalidParameterException("data should not be null");
        }
        if (data == null || data.length != 32 && data.length != 16 && data.length != 48) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "data.length() should be 16 or 32 or 48, not {}", (Object)data.length);
            throw new InvalidParameterException("data.length() should be 16 or 32 or 48, not " + data.length);
        }
        this.data = new byte[data.length + 1];
        this.data[data.length] = crc = Reference.crc8(data);
        for (int i = 0; i < data.length; ++i) {
            this.data[i] = (byte)(data[i] ^ crc);
        }
    }

    private double log2(double x) {
        long n = (long)x;
        if (x == (double)n && n > 0L && n == Long.highestOneBit(n)) {
            return 63 - Long.numberOfLeadingZeros(n);
        }
        return Math.log(x) / LOG_2;
    }

    public Reference(String dataString) {
        if (dataString.matches("^<[a-zA-Z0-9]*>$")) {
            int lenString = dataString.length() - 2;
            len128Bits = (int)Math.ceil(136.0 / this.log2(digits.length()));
            len256Bits = (int)Math.ceil(264.0 / this.log2(digits.length()));
            len384Bits = (int)Math.ceil(392.0 / this.log2(digits.length()));
            if (lenString != len128Bits && lenString != len256Bits && lenString != len384Bits) {
                logger.error(LogMarker.EXCEPTION.getMarker(), " is not a proper encoding of 128, 256, or 384 bits because it has {} digits instead of {}, {}, or {}", (Object)dataString, (Object)lenString, (Object)len128Bits, (Object)len256Bits, (Object)len384Bits);
                throw new InvalidParameterException(dataString + " is not a proper encoding of 128, 256, or 384 bits because it has " + lenString + " digits instead of " + len128Bits + ", " + len256Bits + ", or " + len384Bits);
            }
            int arrayLen = lenString == len128Bits ? 17 : (lenString == len256Bits ? 33 : 49);
            this.data = new byte[arrayLen];
            int[] inDigits = new int[lenString];
            for (int i = 0; i < lenString; ++i) {
                inDigits[i] = digits.indexOf(dataString.charAt(i + 1));
            }
            int[] outDigits = this.convertRadix(inDigits, 62, 256, arrayLen);
            this.data = new byte[arrayLen];
            for (int i = 0; i < arrayLen; ++i) {
                this.data[i] = (byte)outDigits[i];
            }
        } else {
            List<String> words = WordList.words;
            len128Bits = (int)Math.ceil(136.0 / this.log2(words.size()));
            len256Bits = (int)Math.ceil(264.0 / this.log2(words.size()));
            len384Bits = (int)Math.ceil(392.0 / this.log2(words.size()));
            List<String> allWords = Collections.synchronizedList(new ArrayList());
            Matcher m = Pattern.compile("[a-zA-Z]+").matcher(dataString.toLowerCase());
            while (m.find()) {
                allWords.add(m.group());
            }
            int[] indices = new int[allWords.size()];
            int j = 0;
            for (String word : allWords) {
                indices[j++] = words.indexOf(word);
            }
            if (allWords.size() != len128Bits && allWords.size() != len256Bits) {
                throw new InvalidParameterException("there should be " + len128Bits + ", " + len256Bits + ", or " + len384Bits + " words, not " + allWords.size());
            }
            int dataLen = allWords.size() == len128Bits ? 17 : (allWords.size() == len256Bits ? 33 : 49);
            int[] toDigits = this.convertRadix(indices, words.size(), 256, dataLen);
            this.data = new byte[dataLen];
            for (int i = 0; i < dataLen; ++i) {
                this.data[i] = (byte)toDigits[i];
            }
        }
        byte[] dataUnscrambled = (byte[])this.data.clone();
        byte crc = this.data[this.data.length - 1];
        int i = 0;
        while (i < this.data.length - 1) {
            int n = i++;
            dataUnscrambled[n] = (byte)(dataUnscrambled[n] ^ crc);
        }
        crc = Reference.crc8(dataUnscrambled);
        if (this.data[this.data.length - 1] != crc) {
            throw new InvalidParameterException("Invalid string: fails the cyclic redundancy check");
        }
    }

    private int[] convertRadix(int[] number, int fromRadix, int toRadix, int toLength) {
        int i;
        int[] result = new int[toLength];
        BigInteger num = BigInteger.valueOf(0L);
        BigInteger fromR = BigInteger.valueOf(fromRadix);
        BigInteger toR = BigInteger.valueOf(toRadix);
        for (i = 0; i < number.length; ++i) {
            num = num.multiply(fromR);
            num = num.add(BigInteger.valueOf(number[i]));
        }
        for (i = toLength - 1; i >= 0; --i) {
            BigInteger[] pair = num.divideAndRemainder(toR);
            num = pair[0];
            result[i] = pair[1].intValue();
        }
        return result;
    }

    public static byte crc8(byte[] data) {
        int crc = 255;
        for (int i = 0; i < data.length - 1; ++i) {
            crc ^= Byte.toUnsignedInt(data[i]);
            for (int j = 0; j < 8; ++j) {
                crc = crc >>> 1 ^ ((crc & 1) == 0 ? 0 : 178);
            }
        }
        return (byte)(crc ^ 0xFF);
    }

    public String toString() {
        return this.to62();
    }

    public byte[] toBytes() {
        byte[] result = Arrays.copyOfRange(this.data, 0, this.data.length - 1);
        byte crc = this.data[this.data.length - 1];
        int i = 0;
        while (i < this.data.length - 1) {
            int n = i++;
            result[n] = (byte)(result[n] ^ crc);
        }
        return result;
    }

    public String to62Prefix() {
        return this.to62().substring(0, 6) + "...>";
    }

    public String to62() {
        int i;
        int len = (int)Math.ceil((double)(this.data.length * 8) / this.log2(digits.length()));
        int[] fromDigits = new int[this.data.length];
        char[] answer = new char[len];
        for (i = 0; i < this.data.length; ++i) {
            fromDigits[i] = Byte.toUnsignedInt(this.data[i]);
        }
        int[] toDigits = this.convertRadix(fromDigits, 256, digits.length(), len);
        for (i = 0; i < len; ++i) {
            answer[i] = digits.charAt(toDigits[i]);
        }
        return "<" + new String(answer) + ">";
    }

    public String toWords() {
        return this.toWords("+----------\n| ", " ", "\n| ", "\n| ", "\n|\n| ", "\n|\n| ", "\n+----------");
    }

    public String toWords(String indent) {
        return this.toWords(indent + "+----------\n" + indent + "| ", " ", "\n" + indent + "| ", "\n" + indent + "| ", "\n" + indent + "|\n" + indent + "| ", "\n" + indent + "|\n" + indent + "| ", "\n" + indent + "+----------");
    }

    public String toWords(String prefix, String wordSeparator, String lineSeparator1, String lineSeparator2, String groupSeparator1, String groupSeparator2, String suffix) {
        List<String> words = WordList.words;
        int len = (int)Math.ceil((double)(this.data.length * 8) / this.log2(words.size()));
        Object answer = "";
        int[] fromDigits = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            fromDigits[i] = Byte.toUnsignedInt(this.data[i]);
        }
        int[] toDigits = this.convertRadix(fromDigits, 256, words.size(), len);
        for (int i = 0; i < len; ++i) {
            answer = i == 0 ? (String)answer + prefix : (i % 24 == 0 ? (String)answer + groupSeparator1 : (i % 12 == 0 ? (String)answer + groupSeparator2 : (i % 4 == 0 && i % 24 < 12 ? (String)answer + lineSeparator1 : (i % 4 == 0 ? (String)answer + lineSeparator2 : (String)answer + wordSeparator))));
            answer = (String)answer + words.get(toDigits[i]);
        }
        return new String((String)answer + suffix);
    }

    static String toHex(byte[] bytes, int firstIndex, int lastIndex) {
        int last;
        Object ans = "";
        int n = last = lastIndex >= 0 ? lastIndex : bytes.length + lastIndex;
        if (0 > firstIndex || firstIndex > last || last >= bytes.length) {
            return "";
        }
        for (int i = firstIndex; i <= last; ++i) {
            ans = (String)ans + String.format("%02x", bytes[i] & 0xFF);
        }
        return ans;
    }
}

