/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.files.hashmap;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.util.Objects;

final class BucketMutation {
    private final Bytes keyBytes;
    private final int keyHashCode;
    private long oldValue;
    private long value;
    private BucketMutation next;

    BucketMutation(Bytes keyBytes, int keyHashCode, long value) {
        this.keyBytes = Objects.requireNonNull(keyBytes);
        this.keyHashCode = keyHashCode;
        this.value = value;
        this.oldValue = Long.MIN_VALUE;
        this.next = null;
    }

    BucketMutation(Bytes keyBytes, int keyHashCode, long oldValue, long value) {
        this.keyBytes = Objects.requireNonNull(keyBytes);
        this.keyHashCode = keyHashCode;
        this.value = value;
        this.oldValue = oldValue;
        this.next = null;
    }

    void put(Bytes keyBytes, int keyHashCode, long value) {
        BucketMutation mutation = this;
        while (true) {
            if (mutation.keyBytes.equals((Object)keyBytes)) {
                assert (keyHashCode == 0 || mutation.keyHashCode == keyHashCode);
                mutation.value = value;
                mutation.oldValue = Long.MIN_VALUE;
                return;
            }
            if (mutation.next == null) break;
            mutation = mutation.next;
        }
        mutation.next = new BucketMutation(keyBytes, keyHashCode, value);
    }

    void putIfEqual(Bytes keyBytes, int keyHashCode, long oldValue, long value) {
        BucketMutation mutation = this;
        while (true) {
            if (mutation.keyBytes.equals((Object)keyBytes)) {
                assert (keyHashCode == 0 || mutation.keyHashCode == keyHashCode);
                if (mutation.value == oldValue) {
                    mutation.value = value;
                }
                return;
            }
            if (mutation.next == null) break;
            mutation = mutation.next;
        }
        mutation.next = new BucketMutation(keyBytes, keyHashCode, oldValue, value);
    }

    int size() {
        int size = 1;
        BucketMutation mutation = this.next;
        while (mutation != null) {
            ++size;
            mutation = mutation.next;
        }
        return size;
    }

    Bytes getKeyBytes() {
        return this.keyBytes;
    }

    int getKeyHashCode() {
        return this.keyHashCode;
    }

    long getValue() {
        return this.value;
    }

    long getOldValue() {
        return this.oldValue;
    }

    BucketMutation getNext() {
        return this.next;
    }
}

