/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.network;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionManager;
import com.swirlds.platform.network.ConnectionTracker;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.topology.ConnectionManagerFactory;
import com.swirlds.platform.test.fixtures.sync.FakeConnection;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;

public class TestConnectionManagerFactory
implements ConnectionManagerFactory {
    private final NodeId selfId;

    public TestConnectionManagerFactory(NodeId selfId) {
        this.selfId = selfId;
    }

    public ConnectionManager createInboundConnectionManager(@NonNull PeerInfo otherPeer) {
        return new ConnectionManager(this){
            Connection connection;

            public Connection waitForConnection() throws InterruptedException {
                return this.connection;
            }

            public Connection getConnection() {
                return this.connection;
            }

            public void newConnection(Connection connection) throws InterruptedException {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = connection;
            }

            public boolean isOutbound() {
                return false;
            }
        };
    }

    public ConnectionManager createOutboundConnectionManager(final @NonNull NodeId selfId, final @NonNull PeerInfo otherPeer, @NonNull PlatformContext platformContext, @NonNull ConnectionTracker connectionTracker, @NonNull KeysAndCerts ownKeysAndCerts) {
        return new ConnectionManager(){

            public Connection waitForConnection() throws InterruptedException {
                return new FakeConnection(selfId, otherPeer.nodeId());
            }

            public Connection getConnection() {
                return null;
            }

            public void newConnection(Connection connection) throws InterruptedException {
                throw new UnsupportedOperationException("Does not accept connections");
            }

            public boolean isOutbound() {
                return true;
            }
        };
    }
}

