/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.nft;

import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.common.utility.throttle.Throttle;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.nft.NftSimpleQuerier;
import com.swirlds.demo.platform.nft.config.NftConfig;
import com.swirlds.demo.platform.nft.config.NftQueryConfig;
import com.swirlds.demo.platform.nft.config.NftQueryType;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.platform.system.Platform;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NftQueryController {
    private static final Logger logger = LogManager.getLogger(NftQueryController.class);
    private static final SpeedometerMetric.Config NFT_QUERIES_ANSWERED_PER_SECOND_CONFIG = new SpeedometerMetric.Config("NFT", "nftQueriesAnsweredPerSecond").withDescription("number of NFT queries have been answered per second").withFormat("%,9.6f");
    private SpeedometerMetric nftQueriesAnsweredPerSecond;
    private Platform platform;
    private int numberOfThreads;
    private Throttle throttle;
    private NftQueryType queryType;

    public NftQueryController(NftConfig nftConfig, Platform platform) {
        if (nftConfig == null) {
            return;
        }
        NftQueryConfig queryConfig = nftConfig.getQueryConfig();
        if (queryConfig == null) {
            return;
        }
        this.platform = platform;
        this.throttle = new Throttle((double)queryConfig.getQps());
        this.numberOfThreads = queryConfig.getNumberOfThreads();
        this.queryType = queryConfig.getQueryType();
        this.initStats();
    }

    private void initStats() {
        this.nftQueriesAnsweredPerSecond = (SpeedometerMetric)this.platform.getContext().getMetrics().getOrCreate((MetricConfig)NFT_QUERIES_ANSWERED_PER_SECOND_CONFIG);
        NftSimpleQuerier.registerStats(this.platform);
    }

    public void launch() {
        if (this.queryType == null) {
            return;
        }
        ExecutorService queryThreadPool = Executors.newFixedThreadPool(this.numberOfThreads);
        for (int index = 0; index < this.numberOfThreads; ++index) {
            queryThreadPool.execute(this::execute);
        }
    }

    private void execute() {
        while (true) {
            if (!this.throttle.allow()) {
                Thread.onSpinWait();
                continue;
            }
            AutoCloseableWrapper stateWrapper = this.platform.getLatestImmutableState("NFTQueryController.execute()");
            try {
                PlatformTestingToolState state = (PlatformTestingToolState)((Object)stateWrapper.get());
                if (state == null) continue;
                try {
                    this.queryType.execute(state, this.nftQueriesAnsweredPerSecond);
                }
                catch (Exception ex) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to run query {}", (Object)this.queryType, (Object)ex);
                }
                continue;
            }
            finally {
                if (stateWrapper == null) continue;
                stateWrapper.close();
                continue;
            }
            break;
        }
    }
}

