/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.pta;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.FastCopyable;
import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class MapKey
implements SelfSerializable,
Comparable<MapKey>,
FastCopyable {
    public static final long CLASS_ID = 7147260054271562786L;
    @JsonProperty
    private long shardId;
    @JsonProperty
    private long realmId;
    @JsonProperty
    private long accountId;
    private static final Comparator<MapKey> CANONICAL_ORDERING = Comparator.comparing(MapKey::getShardId).thenComparingLong(MapKey::getRealmId).thenComparingLong(MapKey::getAccountId);

    public MapKey(long shardId, long realmId, long accountId) {
        this.shardId = shardId;
        this.realmId = realmId;
        this.accountId = accountId;
    }

    public MapKey() {
    }

    private MapKey(MapKey mapKey) {
        this.shardId = mapKey.shardId;
        this.realmId = mapKey.realmId;
        this.accountId = mapKey.accountId;
    }

    public long getRealmId() {
        return this.realmId;
    }

    public long getShardId() {
        return this.shardId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MapKey mapKey = (MapKey)other;
        return this.shardId == mapKey.shardId && this.realmId == mapKey.realmId && this.accountId == mapKey.accountId;
    }

    public int hashCode() {
        return Objects.hash(this.shardId, this.realmId, this.accountId);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.shardId).append((Object)this.realmId).append((Object)this.accountId).toString();
    }

    @Override
    public int compareTo(MapKey that) {
        return CANONICAL_ORDERING.compare(this, that);
    }

    public long getAccountId() {
        return this.accountId;
    }

    public MapKey copy() {
        return new MapKey(this);
    }

    public void serialize(SerializableDataOutputStream outStream) throws IOException {
        outStream.writeLong(this.shardId);
        outStream.writeLong(this.realmId);
        outStream.writeLong(this.accountId);
    }

    public void deserialize(SerializableDataInputStream inputStream, int version) throws IOException {
        this.shardId = inputStream.readLong();
        this.realmId = inputStream.readLong();
        this.accountId = inputStream.readLong();
    }

    public long getClassId() {
        return 7147260054271562786L;
    }

    public int getVersion() {
        return 1;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

