/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.impl.internal;

import com.swirlds.base.state.MutabilityException;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildTypeException;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.merkle.impl.PartialNaryMerkleInternal;
import com.swirlds.common.merkle.impl.internal.AbstractMerkleNode;
import com.swirlds.common.merkle.interfaces.MerkleParent;
import com.swirlds.common.merkle.route.MerkleRoute;
import java.util.List;
import org.hiero.base.exceptions.ReferenceCountException;

public abstract sealed class AbstractMerkleInternal
extends AbstractMerkleNode
implements MerkleParent
permits PartialBinaryMerkleInternal, PartialNaryMerkleInternal {
    protected AbstractMerkleInternal() {
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    protected AbstractMerkleInternal(AbstractMerkleInternal that) {
        super(that);
    }

    protected abstract void setChildInternal(int var1, MerkleNode var2);

    protected abstract void allocateSpaceForChild(int var1);

    protected abstract void checkChildIndexIsValid(int var1);

    @Override
    public void setChild(int index, MerkleNode child, MerkleRoute childRoute, boolean childMayBeImmutable) {
        this.throwIfInvalidState();
        this.checkChildIndexIsValid(index);
        this.throwIfInvalidChild(index, child, childMayBeImmutable);
        this.allocateSpaceForChild(index);
        MerkleNode oldChild = this.getChild(index);
        if (oldChild == child) {
            return;
        }
        if (!this.isSelfHashing()) {
            this.invalidateHash();
        }
        if (oldChild != null) {
            oldChild.release();
        }
        if (child != null) {
            child.reserve();
            if (childRoute == null) {
                child.setRoute(this.computeRouteForChild(index));
            } else {
                child.setRoute(childRoute);
            }
        }
        this.setChildInternal(index, child);
    }

    private void throwIfInvalidChild(int index, MerkleNode child, boolean childMayBeImmutable) {
        long classId = Long.MIN_VALUE;
        if (child != null) {
            classId = child.getClassId();
            if (!childMayBeImmutable && child.isImmutable()) {
                throw new MutabilityException("Immutable child can not be added to parent. parent = " + this.getClass().getName() + ", child = " + child.getClass().getName());
            }
        }
        if (!this.childHasExpectedType(index, classId)) {
            throw new IllegalChildTypeException(index, classId, this.getClass().getName());
        }
    }

    protected boolean childHasExpectedType(int index, long childClassId) {
        return true;
    }

    private void throwIfInvalidState() {
        if (this.isImmutable()) {
            throw new MutabilityException("Can not set child on immutable parent. " + this.getClass().getName());
        }
        if (this.isDestroyed()) {
            throw new ReferenceCountException("Can not set child on destroyed parent. " + this.getClass().getName());
        }
    }

    private MerkleRoute computeRouteForChild(int index) {
        MerkleNode oldChild;
        MerkleRoute childRoute = null;
        if (this.getNumberOfChildren() > index && (oldChild = this.getChild(index)) != null) {
            childRoute = oldChild.getRoute();
        }
        if (childRoute == null) {
            childRoute = this.getRoute().extendRoute(index);
        }
        return childRoute;
    }

    @Override
    public void addDeserializedChildren(List<MerkleNode> children, int version) {
        for (int childIndex = 0; childIndex < children.size(); ++childIndex) {
            this.setChild(childIndex, children.get(childIndex));
        }
    }

    @Override
    protected final void onDestroy() {
        this.destroyNode();
        for (int index = 0; index < this.getNumberOfChildren(); ++index) {
            MerkleNode child = this.getChild(index);
            if (child == null) continue;
            child.release();
        }
    }

    public void invalidateHash() {
        this.setHash(null);
    }

    @Override
    public void setRoute(MerkleRoute route) {
        if (!this.getRoute().equals(route)) {
            super.setRoute(route);
            this.updateChildRoutes(route);
        }
    }

    protected void updateChildRoutes(MerkleRoute route) {
        for (int index = 0; index < this.getNumberOfChildren(); ++index) {
            MerkleNode child = this.getChild(index);
            if (child == null) continue;
            child.setRoute(this.getRoute().extendRoute(index));
        }
    }
}

