/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.dummy;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.impl.PartialNaryMerkleInternal;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.common.merkle.utility.MerkleLong;
import com.swirlds.common.test.fixtures.dummy.Key;
import com.swirlds.common.test.fixtures.dummy.MerkleKey;
import com.swirlds.fcqueue.FCQueue;
import com.swirlds.merkle.test.fixtures.map.pta.TransactionRecord;
import com.swirlds.merkle.test.fixtures.map.util.MerkleMapTestUtil;
import java.util.Iterator;
import java.util.Objects;
import org.hiero.base.crypto.SerializableHashable;

public class FCQValue<T extends FastCopyable & SerializableHashable>
extends PartialNaryMerkleInternal
implements Iterable<T>,
Keyed<Key>,
MerkleInternal {
    protected static final int FCQ_VALUE_TYPE = 5;
    private static final long CLASS_ID = -7142003953968719204L;

    public boolean childHasExpectedType(int index, long childClassId) {
        switch (index) {
            case 0: {
                return childClassId == 5101867068740213836L;
            }
            case 1: {
                return childClassId == 139236190103L;
            }
            case 2: {
                return childClassId == 8179403978448576541L;
            }
        }
        throw new IllegalChildIndexException(this.getMinimumChildCount(), this.getMaximumChildCount(), index);
    }

    private MerkleLong getBalance() {
        return (MerkleLong)this.getChild(0);
    }

    private void setBalance(MerkleLong balance) {
        this.setChild(0, (MerkleNode)balance);
    }

    public FCQueue<T> getRecords() {
        return (FCQueue)this.getChild(1);
    }

    private void setRecords(FCQueue<T> records) {
        this.setChild(1, (MerkleNode)records);
    }

    public static FCQValue<TransactionRecord> build(long index, long balance, byte[] content) {
        TransactionRecord record = new TransactionRecord(index, balance, content, 180L);
        FCQueue records = new FCQueue();
        records.add((FastCopyable)record);
        return new FCQValue<TransactionRecord>(new MerkleLong(record.getBalance()), records);
    }

    public FCQValue() {
        this.setBalance(new MerkleLong());
        this.setRecords(new FCQueue());
    }

    public FCQValue(MerkleLong balance, FCQueue<T> records) {
        this.setBalance(balance);
        this.setRecords(records);
    }

    private FCQValue(FCQValue<T> sourceValue) {
        super(sourceValue);
        this.setBalance(sourceValue.getBalance());
        this.setRecords(sourceValue.getRecords().copy());
        this.setKey(sourceValue.getKey().copy());
        this.setImmutable(false);
        sourceValue.setImmutable(true);
    }

    public int getFCQRecordsSize() {
        return this.getRecords().size();
    }

    public FCQValue<T> deleteFirst() {
        FCQueue newRecords = this.getRecords().copy();
        newRecords.poll();
        return new FCQValue<T>(this.getBalance().copy(), newRecords);
    }

    public FCQValue<T> transferFrom(long balance, byte[] content) {
        MerkleLong newBalance = new MerkleLong(this.getBalance().getValue() - balance);
        TransactionRecord newFromTransactionRecord = new TransactionRecord(this.getRecords().size(), balance, content, 180L);
        return this.addRecord(newBalance, newFromTransactionRecord);
    }

    public static FCQValue<TransactionRecord> buildDefault() {
        byte[] content = new byte[4096];
        MerkleMapTestUtil.random.nextBytes(content);
        boolean index = false;
        long balance = 100L;
        return FCQValue.build(0L, 100L, content);
    }

    public static FCQValue<TransactionRecord> buildRandom() {
        byte[] content = new byte[100];
        MerkleMapTestUtil.random.nextBytes(content);
        int index = MerkleMapTestUtil.random.nextInt();
        long balance = MerkleMapTestUtil.random.nextLong();
        return FCQValue.build(index, balance, content);
    }

    public static FCQValue<TransactionRecord> buildRandomWithIndex(int index) {
        byte[] content = new byte[100];
        MerkleMapTestUtil.random.nextBytes(content);
        long balance = MerkleMapTestUtil.random.nextLong();
        return FCQValue.build(index, balance, content);
    }

    public FCQValue<T> transferTo(long balance, byte[] content) {
        MerkleLong newBalance = new MerkleLong(this.getBalance().getValue() + balance);
        TransactionRecord newFromTransactionRecord = new TransactionRecord(this.getRecords().size(), balance, content, 180L);
        return this.addRecord(newBalance, newFromTransactionRecord);
    }

    public FCQValue<T> addRecord(long newBalance, T record) {
        return this.addRecord(new MerkleLong(newBalance), record);
    }

    public FCQValue<T> addRecord(MerkleLong newBalance, T record) {
        FCQueue newRecords = this.getRecords().copy();
        newRecords.add(record);
        return new FCQValue<T>(newBalance, newRecords);
    }

    public void addRecord(T record) {
        this.getRecords().add(record);
    }

    public FCQValue<T> copy() {
        this.throwIfImmutable();
        return new FCQValue<T>(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FCQValue)) {
            return false;
        }
        FCQValue that = (FCQValue)o;
        return this.getBalance().equals((Object)that.getBalance()) && Objects.equals(this.getRecords(), that.getRecords());
    }

    public int hashCode() {
        return Objects.hash(this.getBalance(), this.getRecords());
    }

    @Override
    public Iterator<T> iterator() {
        return this.getRecords().iterator();
    }

    public long getClassId() {
        return -7142003953968719204L;
    }

    public int getVersion() {
        return 1;
    }

    public Key getKey() {
        return ((MerkleKey)this.getChild(2)).getKey();
    }

    public void setKey(Key key) {
        this.setChild(2, (MerkleNode)new MerkleKey(key));
    }

    private static class ChildIndices {
        public static final int BALANCE = 0;
        public static final int RECORDS = 1;
        public static final int KEY = 2;
        public static final int CHILD_COUNT = 2;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

