/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.serialize.KeySerializer;
import java.io.IOException;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.base.utility.NonCryptographicHashing;

@ConstructableIgnored
public class ExampleLongLongKeyVariableSize
implements VirtualKey {
    private static final int CURRENT_SERIALIZATION_VERSION = 1235;
    private long value1;
    private long value2;

    public ExampleLongLongKeyVariableSize() {
    }

    public ExampleLongLongKeyVariableSize(long value) {
        this.value1 = value;
        this.value2 = Long.MAX_VALUE - value;
    }

    public ExampleLongLongKeyVariableSize(long value1, long value2) {
        this.value1 = value1;
        this.value2 = value2;
    }

    public long getValue() {
        return this.value1;
    }

    public int hashCode() {
        return NonCryptographicHashing.hash32((long)this.value1, (long)this.value2);
    }

    public void serialize(WritableSequentialData out) {
        int b;
        byte numOfBytes1 = ExampleLongLongKeyVariableSize.computeNonZeroBytes(this.value1);
        byte numOfBytes2 = ExampleLongLongKeyVariableSize.computeNonZeroBytes(this.value2);
        out.writeByte(numOfBytes1);
        out.writeByte(numOfBytes2);
        for (b = numOfBytes1 - 1; b >= 0; --b) {
            out.writeByte((byte)(this.value1 >> b * 8));
        }
        for (b = numOfBytes2 - 1; b >= 0; --b) {
            out.writeByte((byte)(this.value2 >> b * 8));
        }
    }

    public void deserialize(ReadableSequentialData in) {
        byte numOfBytes1 = in.readByte();
        byte numOfBytes2 = in.readByte();
        long value1 = 0L;
        if (numOfBytes1 >= 8) {
            value1 |= ((long)in.readByte() & 0xFFL) << 56;
        }
        if (numOfBytes1 >= 7) {
            value1 |= ((long)in.readByte() & 0xFFL) << 48;
        }
        if (numOfBytes1 >= 6) {
            value1 |= ((long)in.readByte() & 0xFFL) << 40;
        }
        if (numOfBytes1 >= 5) {
            value1 |= ((long)in.readByte() & 0xFFL) << 32;
        }
        if (numOfBytes1 >= 4) {
            value1 |= ((long)in.readByte() & 0xFFL) << 24;
        }
        if (numOfBytes1 >= 3) {
            value1 |= ((long)in.readByte() & 0xFFL) << 16;
        }
        if (numOfBytes1 >= 2) {
            value1 |= ((long)in.readByte() & 0xFFL) << 8;
        }
        if (numOfBytes1 >= 1) {
            value1 |= (long)in.readByte() & 0xFFL;
        }
        this.value1 = value1;
        long value2 = 0L;
        if (numOfBytes2 >= 8) {
            value2 |= ((long)in.readByte() & 0xFFL) << 56;
        }
        if (numOfBytes2 >= 7) {
            value2 |= ((long)in.readByte() & 0xFFL) << 48;
        }
        if (numOfBytes2 >= 6) {
            value2 |= ((long)in.readByte() & 0xFFL) << 40;
        }
        if (numOfBytes2 >= 5) {
            value2 |= ((long)in.readByte() & 0xFFL) << 32;
        }
        if (numOfBytes2 >= 4) {
            value2 |= ((long)in.readByte() & 0xFFL) << 24;
        }
        if (numOfBytes2 >= 3) {
            value2 |= ((long)in.readByte() & 0xFFL) << 16;
        }
        if (numOfBytes2 >= 2) {
            value2 |= ((long)in.readByte() & 0xFFL) << 8;
        }
        if (numOfBytes2 >= 1) {
            value2 |= (long)in.readByte() & 0xFFL;
        }
        this.value2 = value2;
    }

    public ExampleLongLongKeyVariableSize copy() {
        return new ExampleLongLongKeyVariableSize(this.value1, this.value2);
    }

    public void serialize(SerializableDataOutputStream outputStream) throws IOException {
        int b;
        byte numOfBytes1 = ExampleLongLongKeyVariableSize.computeNonZeroBytes(this.value1);
        byte numOfBytes2 = ExampleLongLongKeyVariableSize.computeNonZeroBytes(this.value2);
        outputStream.write((int)numOfBytes1);
        outputStream.write((int)numOfBytes2);
        for (b = numOfBytes1 - 1; b >= 0; --b) {
            outputStream.write((int)((byte)(this.value1 >> b * 8)));
        }
        for (b = numOfBytes2 - 1; b >= 0; --b) {
            outputStream.write((int)((byte)(this.value2 >> b * 8)));
        }
    }

    public void deserialize(SerializableDataInputStream in, int dataVersion) throws IOException {
        assert (dataVersion == this.getVersion()) : "dataVersion=" + dataVersion + " != getVersion()=" + this.getVersion();
        byte numOfBytes1 = in.readByte();
        byte numOfBytes2 = in.readByte();
        long value1 = 0L;
        if (numOfBytes1 >= 8) {
            value1 |= ((long)in.readByte() & 0xFFL) << 56;
        }
        if (numOfBytes1 >= 7) {
            value1 |= ((long)in.readByte() & 0xFFL) << 48;
        }
        if (numOfBytes1 >= 6) {
            value1 |= ((long)in.readByte() & 0xFFL) << 40;
        }
        if (numOfBytes1 >= 5) {
            value1 |= ((long)in.readByte() & 0xFFL) << 32;
        }
        if (numOfBytes1 >= 4) {
            value1 |= ((long)in.readByte() & 0xFFL) << 24;
        }
        if (numOfBytes1 >= 3) {
            value1 |= ((long)in.readByte() & 0xFFL) << 16;
        }
        if (numOfBytes1 >= 2) {
            value1 |= ((long)in.readByte() & 0xFFL) << 8;
        }
        if (numOfBytes1 >= 1) {
            value1 |= (long)in.readByte() & 0xFFL;
        }
        this.value1 = value1;
        long value2 = 0L;
        if (numOfBytes2 >= 8) {
            value2 |= ((long)in.readByte() & 0xFFL) << 56;
        }
        if (numOfBytes2 >= 7) {
            value2 |= ((long)in.readByte() & 0xFFL) << 48;
        }
        if (numOfBytes2 >= 6) {
            value2 |= ((long)in.readByte() & 0xFFL) << 40;
        }
        if (numOfBytes2 >= 5) {
            value2 |= ((long)in.readByte() & 0xFFL) << 32;
        }
        if (numOfBytes2 >= 4) {
            value2 |= ((long)in.readByte() & 0xFFL) << 24;
        }
        if (numOfBytes2 >= 3) {
            value2 |= ((long)in.readByte() & 0xFFL) << 16;
        }
        if (numOfBytes2 >= 2) {
            value2 |= ((long)in.readByte() & 0xFFL) << 8;
        }
        if (numOfBytes2 >= 1) {
            value2 |= (long)in.readByte() & 0xFFL;
        }
        this.value2 = value2;
    }

    public long getClassId() {
        return 6484134134848452L;
    }

    public int getVersion() {
        return 1235;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExampleLongLongKeyVariableSize)) {
            return false;
        }
        ExampleLongLongKeyVariableSize that = (ExampleLongLongKeyVariableSize)o;
        return this.value1 == that.value1 && this.value2 == that.value2;
    }

    public long getValue1() {
        return this.value1;
    }

    public long getValue2() {
        return this.value2;
    }

    public String toString() {
        return "ExampleLongLongKeyVariableSize{value1=" + this.value1 + ", value2=" + this.value2 + "}";
    }

    static byte computeNonZeroBytes(long num) {
        if (num == 0L) {
            return 1;
        }
        return (byte)Math.ceil((double)(64 - Long.numberOfLeadingZeros(num)) / 8.0);
    }

    public static class Serializer
    implements KeySerializer<ExampleLongLongKeyVariableSize> {
        private static final long CLASS_ID = 7388127425569490153L;

        public long getClassId() {
            return 7388127425569490153L;
        }

        public int getVersion() {
            return 1;
        }

        public int getTypicalSerializedSize() {
            return 10;
        }

        public int getSerializedSize() {
            return -1;
        }

        public long getCurrentDataVersion() {
            return 1235L;
        }

        public int getSerializedSize(ExampleLongLongKeyVariableSize data) {
            return 2 + ExampleLongLongKeyVariableSize.computeNonZeroBytes(data.value1) + ExampleLongLongKeyVariableSize.computeNonZeroBytes(data.value2);
        }

        public ExampleLongLongKeyVariableSize deserialize(ReadableSequentialData in) {
            ExampleLongLongKeyVariableSize key = new ExampleLongLongKeyVariableSize();
            key.deserialize(in);
            return key;
        }

        public void serialize(ExampleLongLongKeyVariableSize data, WritableSequentialData out) {
            data.serialize(out);
        }

        public boolean equals(BufferedData buffer, ExampleLongLongKeyVariableSize keyToCompare) {
            byte numOfBytes1 = buffer.readByte();
            byte numOfBytes2 = buffer.readByte();
            long value1 = 0L;
            if (numOfBytes1 >= 8) {
                value1 |= ((long)buffer.readByte() & 0xFFL) << 56;
            }
            if (numOfBytes1 >= 7) {
                value1 |= ((long)buffer.readByte() & 0xFFL) << 48;
            }
            if (numOfBytes1 >= 6) {
                value1 |= ((long)buffer.readByte() & 0xFFL) << 40;
            }
            if (numOfBytes1 >= 5) {
                value1 |= ((long)buffer.readByte() & 0xFFL) << 32;
            }
            if (numOfBytes1 >= 4) {
                value1 |= ((long)buffer.readByte() & 0xFFL) << 24;
            }
            if (numOfBytes1 >= 3) {
                value1 |= ((long)buffer.readByte() & 0xFFL) << 16;
            }
            if (numOfBytes1 >= 2) {
                value1 |= ((long)buffer.readByte() & 0xFFL) << 8;
            }
            if (numOfBytes1 >= 1) {
                value1 |= (long)buffer.readByte() & 0xFFL;
            }
            long value2 = 0L;
            if (numOfBytes2 >= 8) {
                value2 |= ((long)buffer.readByte() & 0xFFL) << 56;
            }
            if (numOfBytes2 >= 7) {
                value2 |= ((long)buffer.readByte() & 0xFFL) << 48;
            }
            if (numOfBytes2 >= 6) {
                value2 |= ((long)buffer.readByte() & 0xFFL) << 40;
            }
            if (numOfBytes2 >= 5) {
                value2 |= ((long)buffer.readByte() & 0xFFL) << 32;
            }
            if (numOfBytes2 >= 4) {
                value2 |= ((long)buffer.readByte() & 0xFFL) << 24;
            }
            if (numOfBytes2 >= 3) {
                value2 |= ((long)buffer.readByte() & 0xFFL) << 16;
            }
            if (numOfBytes2 >= 2) {
                value2 |= ((long)buffer.readByte() & 0xFFL) << 8;
            }
            if (numOfBytes2 >= 1) {
                value2 |= (long)buffer.readByte() & 0xFFL;
            }
            return value1 == keyToCompare.getValue1() && value2 == keyToCompare.getValue2();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Serializer;
        }

        private static final class ClassVersion {
            public static final int ORIGINAL = 1;

            private ClassVersion() {
            }
        }
    }
}

