/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures;

import com.swirlds.common.formatting.TextTable;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.scratchpad.Scratchpad;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.SelfSerializable;

public class SimpleScratchpad<K extends Enum<K>>
implements Scratchpad<K> {
    private static final Logger logger = LogManager.getLogger();
    private final Map<K, SelfSerializable> data = new HashMap<K, SelfSerializable>();

    public void logContents() {
        TextTable table = new TextTable().setBordersEnabled(false);
        for (Enum field : this.data.keySet()) {
            SelfSerializable value = this.data.get(field);
            if (value == null) {
                table.addToRow(new Object[]{field.name(), "null"});
                continue;
            }
            table.addRow(new Object[]{field.name(), value.toString()});
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Scratchpad contents:\n{}", (Object)table.render());
    }

    @Nullable
    public <V extends SelfSerializable> V get(@NonNull K key) {
        return (V)this.data.get(key);
    }

    @Nullable
    public <V extends SelfSerializable> V set(@NonNull K key, @Nullable V value) {
        return (V)this.data.put(key, value);
    }

    public void atomicOperation(@NonNull Consumer<Map<K, SelfSerializable>> operation) {
        operation.accept(this.data);
    }

    public void atomicOperation(@NonNull Function<Map<K, SelfSerializable>, Boolean> operation) {
        operation.apply(this.data);
    }

    public void clear() {
        this.data.clear();
    }
}

