/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.test.fixtures;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.utility.CommonUtils;

public final class EcdsaUtils {
    public static final int SIGNATURE_LENGTH = 64;
    public static final int BIG_ENDIAN_SIZE = 32;
    public static final byte[] WELL_KNOWN_DIGEST = CommonUtils.unhex((String)"744c77a7af70b3a522009f0a963384eccfa77662a594d6e0247dfba095eb48d5");

    private EcdsaUtils() {
    }

    public static KeyPair genEcdsaSecp256k1KeyPair() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        ECGenParameterSpec ecSpec = new ECGenParameterSpec(SignatureType.ECDSA_SECP256K1.ellipticalCurve());
        KeyPairGenerator generator = KeyPairGenerator.getInstance(SignatureType.ECDSA_SECP256K1.keyAlgorithm(), SignatureType.ECDSA_SECP256K1.provider());
        generator.initialize(ecSpec, new SecureRandom());
        return generator.generateKeyPair();
    }

    public static byte[] signWellKnownDigestWithEcdsaSecp256k1(PrivateKey privateKey) {
        return EcdsaUtils.signDigestWithEcdsaSecp256k1(privateKey, WELL_KNOWN_DIGEST);
    }

    public static byte[] signDigestWithEcdsaSecp256k1(PrivateKey privateKey, byte[] digest) {
        try {
            Signature ecdsaSign = Signature.getInstance(SignatureType.ECDSA_SECP256K1.signingAlgorithm(), SignatureType.ECDSA_SECP256K1.provider());
            ecdsaSign.initSign(privateKey);
            ecdsaSign.update(digest);
            byte[] asn1Sig = ecdsaSign.sign();
            return EcdsaUtils.rawEcdsaSigFromAsn1Der(asn1Sig);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException fatal) {
            throw new IllegalStateException(fatal);
        }
    }

    public static byte[] asRawEcdsaSecp256k1Key(ECPublicKey cryptoPubKey) {
        byte[] encPubKey = cryptoPubKey.getEncoded();
        return Arrays.copyOfRange(encPubKey, encPubKey.length - 64, encPubKey.length);
    }

    private static byte[] rawEcdsaSigFromAsn1Der(byte[] derSig) {
        int origSLen;
        int finalSLen;
        int origRLen;
        int finalRLen;
        int R_LEN_INDEX = 3;
        byte[] rawBytes = new byte[64];
        int rStart = 4;
        for (finalRLen = origRLen = derSig[3] & 0xFF; finalRLen > 32; --finalRLen) {
            ++rStart;
        }
        System.arraycopy(derSig, rStart, rawBytes, 32 - finalRLen, Math.min(32, origRLen));
        int sLenPos = 3 + (derSig[3] & 0xFF) + 2;
        int sStart = sLenPos + 1;
        for (finalSLen = origSLen = derSig[sLenPos] & 0xFF; finalSLen > 32; --finalSLen) {
            ++sStart;
        }
        System.arraycopy(derSig, sStart, rawBytes, 32 + (32 - finalSLen), Math.min(32, origSLen));
        return rawBytes;
    }
}

