/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.emitter;

import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.emitter.AbstractEventEmitter;
import com.swirlds.platform.test.fixtures.event.emitter.EventEmitter;
import java.util.LinkedList;
import java.util.List;

public class CollectingEventEmitter
extends AbstractEventEmitter {
    private final LinkedList<EventImpl> collectedEvents = new LinkedList();
    private final EventEmitter emitter;

    public CollectingEventEmitter(EventEmitter emitter) {
        super(emitter.getGraphGenerator());
        this.emitter = emitter;
    }

    public CollectingEventEmitter(CollectingEventEmitter that) {
        this(that.emitter.cleanCopy());
    }

    public CollectingEventEmitter(CollectingEventEmitter that, long seed) {
        this(that.emitter.cleanCopy(seed));
    }

    @Override
    public EventImpl emitEvent() {
        EventImpl event = this.emitter.emitEvent();
        this.collectedEvents.add(event);
        ++this.numEventsEmitted;
        return event;
    }

    public List<EventImpl> getCollectedEvents() {
        return new LinkedList<EventImpl>(this.collectedEvents);
    }

    @Override
    public void reset() {
        super.reset();
        this.emitter.reset();
        this.collectedEvents.clear();
    }

    @Override
    public CollectingEventEmitter cleanCopy() {
        return new CollectingEventEmitter(this);
    }

    @Override
    public CollectingEventEmitter cleanCopy(long seed) {
        return new CollectingEventEmitter(this, seed);
    }

    @Override
    public void setCheckpoint(long checkpoint) {
        this.emitter.setCheckpoint(checkpoint);
    }
}

